/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import java.util.NoSuchElementException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;

public final class RelationshipDenseSelectionIterator<R>
extends RelationshipDenseSelection
implements ResourceIterator<R> {
    private RelationshipFactory<R> factory;
    private long next;

    RelationshipDenseSelectionIterator(RelationshipFactory<R> factory) {
        this.factory = factory;
        this.next = -2L;
    }

    @Override
    public boolean hasNext() {
        if (this.next == -2L) {
            this.fetchNext();
            this.next = this.relationshipCursor.relationshipReference();
        }
        if (this.next == -1L) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        R current = this.factory.relationship(this.next, this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.type(), this.relationshipCursor.targetNodeReference());
        if (!this.fetchNext()) {
            this.close();
            this.next = -1L;
        } else {
            this.next = this.relationshipCursor.relationshipReference();
        }
        return current;
    }
}

