/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipDenseSelectionIterator;
import org.neo4j.internal.kernel.api.helpers.RelationshipFactory;
import org.neo4j.internal.kernel.api.helpers.RelationshipSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelection;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionCursor;
import org.neo4j.internal.kernel.api.helpers.RelationshipSparseSelectionIterator;

public final class RelationshipSelections {
    static final long UNINITIALIZED = -2L;
    static final long NO_ID = -1L;

    private RelationshipSelections() {
        throw new UnsupportedOperationException("Do not instantiate");
    }

    public static RelationshipSelectionCursor outgoingCursor(CursorFactory cursors, NodeCursor node, int[] types2) {
        if (node.isDense()) {
            RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
            RelationshipSelections.setupOutgoingDense(selectionCursor, cursors, node, types2);
            return selectionCursor;
        }
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        RelationshipSelections.setupOutgoingSparse(selectionCursor, cursors, node, types2);
        return selectionCursor;
    }

    public static RelationshipSelectionCursor incomingCursor(CursorFactory cursors, NodeCursor node, int[] types2) {
        if (node.isDense()) {
            RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
            RelationshipSelections.setupIncomingDense(selectionCursor, cursors, node, types2);
            return selectionCursor;
        }
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        RelationshipSelections.setupIncomingSparse(selectionCursor, cursors, node, types2);
        return selectionCursor;
    }

    public static RelationshipSelectionCursor allCursor(CursorFactory cursors, NodeCursor node, int[] types2) {
        if (node.isDense()) {
            RelationshipDenseSelectionCursor selectionCursor = new RelationshipDenseSelectionCursor();
            RelationshipSelections.setupAllDense(selectionCursor, cursors, node, types2);
            return selectionCursor;
        }
        RelationshipSparseSelectionCursor selectionCursor = new RelationshipSparseSelectionCursor();
        RelationshipSelections.setupAllSparse(selectionCursor, cursors, node, types2);
        return selectionCursor;
    }

    public static <T> ResourceIterator<T> outgoingIterator(CursorFactory cursors, NodeCursor node, int[] types2, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipSelections.setupOutgoingDense(selectionIterator, cursors, node, types2);
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipSelections.setupOutgoingSparse(selectionIterator, cursors, node, types2);
        return selectionIterator;
    }

    public static <T> ResourceIterator<T> incomingIterator(CursorFactory cursors, NodeCursor node, int[] types2, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipSelections.setupIncomingDense(selectionIterator, cursors, node, types2);
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipSelections.setupIncomingSparse(selectionIterator, cursors, node, types2);
        return selectionIterator;
    }

    public static <T> ResourceIterator<T> allIterator(CursorFactory cursors, NodeCursor node, int[] types2, RelationshipFactory<T> factory) {
        if (node.isDense()) {
            RelationshipDenseSelectionIterator<T> selectionIterator = new RelationshipDenseSelectionIterator<T>(factory);
            RelationshipSelections.setupAllDense(selectionIterator, cursors, node, types2);
            return selectionIterator;
        }
        RelationshipSparseSelectionIterator<T> selectionIterator = new RelationshipSparseSelectionIterator<T>(factory);
        RelationshipSelections.setupAllSparse(selectionIterator, cursors, node, types2);
        return selectionIterator;
    }

    private static void setupOutgoingDense(RelationshipDenseSelection denseSelection, CursorFactory cursors, NodeCursor node, int[] types2) {
        RelationshipGroupCursor groupCursor = cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.relationships(groupCursor);
            denseSelection.outgoing(groupCursor, traversalCursor, types2);
        }
        catch (Throwable t) {
            groupCursor.close();
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupIncomingDense(RelationshipDenseSelection denseSelection, CursorFactory cursors, NodeCursor node, int[] types2) {
        RelationshipGroupCursor groupCursor = cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.relationships(groupCursor);
            denseSelection.incoming(groupCursor, traversalCursor, types2);
        }
        catch (Throwable t) {
            groupCursor.close();
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupAllDense(RelationshipDenseSelection denseSelection, CursorFactory cursors, NodeCursor node, int[] types2) {
        RelationshipGroupCursor groupCursor = cursors.allocateRelationshipGroupCursor();
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.relationships(groupCursor);
            denseSelection.all(groupCursor, traversalCursor, types2);
        }
        catch (Throwable t) {
            groupCursor.close();
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupOutgoingSparse(RelationshipSparseSelection sparseSelection, CursorFactory cursors, NodeCursor node, int[] types2) {
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.allRelationships(traversalCursor);
            sparseSelection.outgoing(traversalCursor, types2);
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupIncomingSparse(RelationshipSparseSelection sparseSelection, CursorFactory cursors, NodeCursor node, int[] types2) {
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.allRelationships(traversalCursor);
            sparseSelection.incoming(traversalCursor, types2);
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }

    private static void setupAllSparse(RelationshipSparseSelection sparseSelection, CursorFactory cursors, NodeCursor node, int[] types2) {
        RelationshipTraversalCursor traversalCursor = cursors.allocateRelationshipTraversalCursor();
        try {
            node.allRelationships(traversalCursor);
            sparseSelection.all(traversalCursor, types2);
        }
        catch (Throwable t) {
            traversalCursor.close();
            throw t;
        }
    }
}

