/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.List;
import java.util.Map;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;

public class DefaultParameterValue {
    private final Object value;
    private final Neo4jTypes.AnyType type;

    public DefaultParameterValue(Object value2, Neo4jTypes.AnyType type) {
        this.value = value2;
        this.type = type;
    }

    public Object value() {
        return this.value;
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public static DefaultParameterValue ntString(String value2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTString);
    }

    public static DefaultParameterValue ntInteger(long value2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTInteger);
    }

    public static DefaultParameterValue ntFloat(double value2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTFloat);
    }

    public static DefaultParameterValue ntBoolean(boolean value2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTBoolean);
    }

    public static DefaultParameterValue ntMap(Map<String, Object> value2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTMap);
    }

    public static DefaultParameterValue ntByteArray(byte[] value2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTByteArray);
    }

    public static DefaultParameterValue ntList(List<?> value2, Neo4jTypes.AnyType inner2) {
        return new DefaultParameterValue(value2, Neo4jTypes.NTList(inner2));
    }

    public static DefaultParameterValue nullValue(Neo4jTypes.AnyType type) {
        return new DefaultParameterValue(null, type);
    }

    public String toString() {
        return "DefaultParameterValue{value=" + this.value + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultParameterValue that = (DefaultParameterValue)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result2 = this.value != null ? this.value.hashCode() : 0;
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }
}

