/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Objects;
import java.util.Optional;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;

public class FieldSignature {
    private final String name;
    private final Neo4jTypes.AnyType type;
    private final DefaultParameterValue defaultValue;
    private final boolean deprecated;

    public static FieldSignature inputField(String name, Neo4jTypes.AnyType type) {
        return new FieldSignature(name, type, null, false);
    }

    public static FieldSignature inputField(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue) {
        return new FieldSignature(name, type, Objects.requireNonNull(defaultValue, "defaultValue"), false);
    }

    public static FieldSignature inputField(String name, Neo4jTypes.AnyType type, final InputMapper mapper) {
        return new FieldSignature(name, type, null, false){

            @Override
            public Object map(Object input2) {
                return mapper.map(input2);
            }

            @Override
            public Object map(AnyValue input2, ValueMapper<Object> valueMapper) {
                return mapper.map(input2).map(valueMapper);
            }

            @Override
            public boolean needsMapping() {
                return true;
            }
        };
    }

    public static FieldSignature inputField(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue, final InputMapper mapper) {
        return new FieldSignature(name, type, Objects.requireNonNull(defaultValue, "defaultValue"), false){

            @Override
            public Object map(Object input2) {
                return mapper.map(input2);
            }

            @Override
            public Object map(AnyValue input2, ValueMapper<Object> valueMapper) {
                return mapper.map(input2).map(valueMapper);
            }

            @Override
            public boolean needsMapping() {
                return true;
            }
        };
    }

    public static FieldSignature outputField(String name, Neo4jTypes.AnyType type) {
        return FieldSignature.outputField(name, type, false);
    }

    public static FieldSignature outputField(String name, Neo4jTypes.AnyType type, boolean deprecated2) {
        return new FieldSignature(name, type, null, deprecated2);
    }

    private FieldSignature(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue, boolean deprecated2) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.defaultValue = defaultValue;
        this.deprecated = deprecated2;
        if (defaultValue != null && !type.equals(defaultValue.neo4jType())) {
            throw new IllegalArgumentException(String.format("Default value does not have a valid type, field type was %s, but value type was %s.", type.toString(), defaultValue.neo4jType().toString()));
        }
    }

    public boolean needsMapping() {
        return false;
    }

    public Object map(Object input2) {
        return input2;
    }

    public Object map(AnyValue input2, ValueMapper<Object> mapper) {
        return input2.map(mapper);
    }

    public String name() {
        return this.name;
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public Optional<DefaultParameterValue> defaultValue() {
        return Optional.ofNullable(this.defaultValue);
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append(this.name);
        if (this.defaultValue != null) {
            result2.append(" = ").append(this.defaultValue.value());
        }
        return result2.append(" :: ").append(this.type).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldSignature that = (FieldSignature)o;
        return this.name.equals(that.name) && this.type.equals(that.type) && Objects.equals(this.defaultValue, that.defaultValue) && this.deprecated == that.deprecated;
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.type.hashCode();
        return result2;
    }

    public static interface InputMapper {
        public Object map(Object var1);

        public AnyValue map(AnyValue var1);
    }
}

