/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.schema;

import java.util.function.Predicate;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorSupplier;
import org.neo4j.storageengine.api.EntityType;

public class SchemaDescriptorPredicates {
    private SchemaDescriptorPredicates() {
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasLabel(int labelId) {
        return supplier -> {
            SchemaDescriptor schema = supplier.schema();
            return schema.entityType() == EntityType.NODE && ArrayUtils.contains(schema.getEntityTokenIds(), labelId);
        };
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasRelType(int relTypeId) {
        return supplier -> {
            SchemaDescriptor schema = supplier.schema();
            return schema.entityType() == EntityType.RELATIONSHIP && ArrayUtils.contains(schema.getEntityTokenIds(), relTypeId);
        };
    }

    public static <T extends SchemaDescriptorSupplier> Predicate<T> hasProperty(int propertyId) {
        return supplier -> SchemaDescriptorPredicates.hasProperty(supplier, propertyId);
    }

    public static boolean hasLabel(SchemaDescriptorSupplier supplier, int labelId) {
        SchemaDescriptor schema = supplier.schema();
        return schema.entityType() == EntityType.NODE && ArrayUtils.contains(schema.getEntityTokenIds(), labelId);
    }

    public static boolean hasRelType(SchemaDescriptorSupplier supplier, int relTypeId) {
        SchemaDescriptor schema = supplier.schema();
        return schema.entityType() == EntityType.RELATIONSHIP && ArrayUtils.contains(schema.getEntityTokenIds(), relTypeId);
    }

    public static boolean hasProperty(SchemaDescriptorSupplier supplier, int propertyId) {
        int[] schemaProperties;
        for (int schemaProp : schemaProperties = supplier.schema().getPropertyIds()) {
            if (schemaProp != propertyId) continue;
            return true;
        }
        return false;
    }
}

