/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.internal.diagnostics.DiagnosticsExtractor;
import org.neo4j.internal.diagnostics.DiagnosticsPhase;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.logging.Logger;

public enum NeoStoresDiagnostics implements DiagnosticsExtractor<NeoStores>
{
    NEO_STORE_VERSIONS("Store versions:"){

        @Override
        void dump(NeoStores source, Logger logger) {
            source.logVersions(logger);
        }
    }
    ,
    NEO_STORE_ID_USAGE("Id usage:"){

        @Override
        void dump(NeoStores source, Logger logger) {
            source.logIdUsage(logger);
        }
    }
    ,
    NEO_STORE_RECORDS("Neostore records:"){

        @Override
        void dump(NeoStores source, Logger logger) {
            source.getMetaDataStore().logRecords(logger);
        }
    };

    private final String message;

    private NeoStoresDiagnostics(String message) {
        this.message = message;
    }

    @Override
    public void dumpDiagnostics(NeoStores source, DiagnosticsPhase phase, Logger logger) {
        if (this.applicable(phase)) {
            logger.log(this.message);
            this.dump(source, logger);
        }
    }

    boolean applicable(DiagnosticsPhase phase) {
        return phase.isInitialization() || phase.isExplicitlyRequested();
    }

    abstract void dump(NeoStores var1, Logger var2);
}

