/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class AlreadyConstrainedException
extends SchemaKernelException {
    private static final String NO_CONTEXT_FORMAT = "Already constrained %s.";
    private static final String ALREADY_CONSTRAINED_MESSAGE_PREFIX = "Constraint already exists: ";
    private static final String INDEX_CONTEXT_FORMAT = "There is a uniqueness constraint on %s, so an index is already created that matches this.";
    private final ConstraintDescriptor constraint;
    private final SchemaKernelException.OperationContext context;

    public AlreadyConstrainedException(ConstraintDescriptor constraint, SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup) {
        super((Status)Status.Schema.ConstraintAlreadyExists, AlreadyConstrainedException.constructUserMessage(context, tokenNameLookup, constraint));
        this.constraint = constraint;
        this.context = context;
    }

    public ConstraintDescriptor constraint() {
        return this.constraint;
    }

    private static String constructUserMessage(SchemaKernelException.OperationContext context, TokenNameLookup tokenNameLookup, ConstraintDescriptor constraint) {
        switch (context) {
            case INDEX_CREATION: {
                return AlreadyConstrainedException.messageWithLabelAndPropertyName(tokenNameLookup, INDEX_CONTEXT_FORMAT, constraint.schema());
            }
            case CONSTRAINT_CREATION: {
                return ALREADY_CONSTRAINED_MESSAGE_PREFIX + constraint.prettyPrint(tokenNameLookup);
            }
        }
        return String.format(NO_CONTEXT_FORMAT, constraint);
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return AlreadyConstrainedException.constructUserMessage(this.context, tokenNameLookup, this.constraint);
    }
}

