/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Exceptions;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;

public class UniquePropertyValueValidationException
extends ConstraintValidationException {
    private final Set<IndexEntryConflictException> conflicts;

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, IndexEntryConflictException conflict) {
        this(constraint, phase, Collections.singleton(conflict));
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Set<IndexEntryConflictException> conflicts) {
        super(constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", UniquePropertyValueValidationException.buildCauseChain(conflicts));
        this.conflicts = conflicts;
    }

    private static IndexEntryConflictException buildCauseChain(Set<IndexEntryConflictException> conflicts) {
        IndexEntryConflictException chainedConflicts = null;
        for (IndexEntryConflictException conflict : conflicts) {
            chainedConflicts = Exceptions.chain(chainedConflicts, conflict);
        }
        return chainedConflicts;
    }

    public UniquePropertyValueValidationException(IndexBackedConstraintDescriptor constraint, ConstraintValidationException.Phase phase, Throwable cause) {
        super(constraint, phase, phase == ConstraintValidationException.Phase.VERIFICATION ? "Existing data" : "New data", cause);
        this.conflicts = Collections.emptySet();
    }

    @Override
    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        SchemaDescriptor schema = this.constraint.schema();
        StringBuilder message = new StringBuilder();
        Iterator<IndexEntryConflictException> iterator2 = this.conflicts.iterator();
        while (iterator2.hasNext()) {
            IndexEntryConflictException conflict = iterator2.next();
            message.append(conflict.evidenceMessage(tokenNameLookup, schema));
            if (!iterator2.hasNext()) continue;
            message.append(System.lineSeparator());
        }
        return message.toString();
    }

    public Set<IndexEntryConflictException> conflicts() {
        return this.conflicts;
    }
}

