/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Base64;
import org.neo4j.string.UTF8;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

public final class ArrayEncoder {
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();

    private ArrayEncoder() {
        throw new AssertionError((Object)"Not for instantiation!");
    }

    public static String encode(Value array) {
        if (!Values.isArrayValue(array)) {
            throw new IllegalArgumentException("Only works with arrays");
        }
        ValueEncoder encoder = new ValueEncoder();
        array.writeTo(encoder);
        return encoder.result();
    }

    static class ValueEncoder
    implements ValueWriter<RuntimeException> {
        private StringBuilder builder = new StringBuilder();

        ValueEncoder() {
        }

        public String result() {
            return this.builder.toString();
        }

        @Override
        public void writeNull() {
        }

        @Override
        public void writeBoolean(boolean value2) {
            this.builder.append(value2);
            this.builder.append('|');
        }

        @Override
        public void writeInteger(byte value2) {
            this.builder.append((double)value2);
            this.builder.append('|');
        }

        @Override
        public void writeInteger(short value2) {
            this.builder.append((double)value2);
            this.builder.append('|');
        }

        @Override
        public void writeInteger(int value2) {
            this.builder.append((double)value2);
            this.builder.append('|');
        }

        @Override
        public void writeInteger(long value2) {
            this.builder.append((double)value2);
            this.builder.append('|');
        }

        @Override
        public void writeFloatingPoint(float value2) {
            this.builder.append((double)value2);
            this.builder.append('|');
        }

        @Override
        public void writeFloatingPoint(double value2) {
            this.builder.append(value2);
            this.builder.append('|');
        }

        @Override
        public void writeString(String value2) {
            this.builder.append(base64Encoder.encodeToString(UTF8.encode(value2)));
            this.builder.append('|');
        }

        @Override
        public void writeString(char value2) {
            this.builder.append(base64Encoder.encodeToString(UTF8.encode(Character.toString(value2))));
            this.builder.append('|');
        }

        @Override
        public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws RuntimeException {
            this.builder.append(crs.getTable().getTableId());
            this.builder.append(':');
            this.builder.append(crs.getCode());
            this.builder.append(':');
            int index = 0;
            for (double c : coordinate) {
                if (index > 0) {
                    this.builder.append(';');
                }
                this.builder.append(c);
                ++index;
            }
            this.builder.append('|');
        }

        @Override
        public void writeDuration(long months, long days, long seconds, int nanos) throws RuntimeException {
            this.builder.append(DurationValue.duration(months, days, seconds, nanos).prettyPrint());
            this.builder.append('|');
        }

        @Override
        public void writeDate(LocalDate localDate) throws RuntimeException {
            this.builder.append(DateValue.date(localDate).prettyPrint());
            this.builder.append('|');
        }

        @Override
        public void writeLocalTime(LocalTime localTime) throws RuntimeException {
            this.builder.append(LocalTimeValue.localTime(localTime).prettyPrint());
            this.builder.append('|');
        }

        @Override
        public void writeTime(OffsetTime offsetTime) throws RuntimeException {
            this.builder.append(TimeValue.time(offsetTime).prettyPrint());
            this.builder.append('|');
        }

        @Override
        public void writeLocalDateTime(LocalDateTime localDateTime) throws RuntimeException {
            this.builder.append(LocalDateTimeValue.localDateTime(localDateTime).prettyPrint());
            this.builder.append('|');
        }

        @Override
        public void writeDateTime(ZonedDateTime zonedDateTime) throws RuntimeException {
            this.builder.append(DateTimeValue.datetime(zonedDateTime).prettyPrint());
            this.builder.append('|');
        }

        @Override
        public void beginArray(int size2, ValueWriter.ArrayType arrayType) {
            if (size2 > 0) {
                this.builder.append(this.typeChar(arrayType));
            }
        }

        @Override
        public void endArray() {
        }

        @Override
        public void writeByteArray(byte[] value2) {
            this.builder.append('D');
            for (byte b : value2) {
                this.builder.append((double)b);
                this.builder.append('|');
            }
        }

        private char typeChar(ValueWriter.ArrayType arrayType) {
            switch (arrayType) {
                case BOOLEAN: {
                    return 'Z';
                }
                case BYTE: {
                    return 'D';
                }
                case SHORT: {
                    return 'D';
                }
                case INT: {
                    return 'D';
                }
                case LONG: {
                    return 'D';
                }
                case FLOAT: {
                    return 'D';
                }
                case DOUBLE: {
                    return 'D';
                }
                case CHAR: {
                    return 'L';
                }
                case STRING: {
                    return 'L';
                }
                case POINT: {
                    return 'P';
                }
                case ZONED_DATE_TIME: {
                    return 'T';
                }
                case LOCAL_DATE_TIME: {
                    return 'T';
                }
                case DATE: {
                    return 'T';
                }
                case ZONED_TIME: {
                    return 'T';
                }
                case LOCAL_TIME: {
                    return 'T';
                }
                case DURATION: {
                    return 'A';
                }
            }
            throw new UnsupportedOperationException("Not supported array type: " + (Object)((Object)arrayType));
        }
    }
}

