/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.File;
import java.io.IOException;
import org.neo4j.internal.kernel.api.IndexCapability;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.MisconfiguredIndexException;
import org.neo4j.internal.kernel.api.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;

public abstract class IndexProvider
extends LifecycleAdapter {
    public static final IndexProvider EMPTY = new IndexProvider(new IndexProviderDescriptor("no-index-provider", "1.0"), IndexDirectoryStructure.NONE){
        private final IndexAccessor singleWriter = IndexAccessor.EMPTY;
        private final IndexPopulator singlePopulator = IndexPopulator.EMPTY;

        @Override
        public IndexAccessor getOnlineAccessor(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return this.singleWriter;
        }

        @Override
        public IndexPopulator getPopulator(StoreIndexDescriptor descriptor, IndexSamplingConfig samplingConfig) {
            return this.singlePopulator;
        }

        @Override
        public InternalIndexState getInitialState(StoreIndexDescriptor descriptor) {
            return InternalIndexState.ONLINE;
        }

        @Override
        public IndexCapability getCapability(StoreIndexDescriptor descriptor) {
            return IndexCapability.NO_CAPABILITY;
        }

        @Override
        public StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction fs, PageCache pageCache) {
            return StoreMigrationParticipant.NOT_PARTICIPATING;
        }

        @Override
        public String getPopulationFailure(StoreIndexDescriptor descriptor) throws IllegalStateException {
            throw new IllegalStateException();
        }
    };
    private final IndexProviderDescriptor providerDescriptor;
    private final IndexDirectoryStructure.Factory directoryStructureFactory;
    private final IndexDirectoryStructure directoryStructure;

    protected IndexProvider(IndexProvider copySource) {
        this(copySource.providerDescriptor, copySource.directoryStructureFactory);
    }

    protected IndexProvider(IndexProviderDescriptor descriptor, IndexDirectoryStructure.Factory directoryStructureFactory) {
        this.directoryStructureFactory = directoryStructureFactory;
        assert (descriptor != null);
        this.providerDescriptor = descriptor;
        this.directoryStructure = directoryStructureFactory.forProvider(descriptor);
    }

    public IndexDescriptor bless(IndexDescriptor index) throws MisconfiguredIndexException {
        return index;
    }

    public abstract IndexPopulator getPopulator(StoreIndexDescriptor var1, IndexSamplingConfig var2);

    public abstract IndexAccessor getOnlineAccessor(StoreIndexDescriptor var1, IndexSamplingConfig var2) throws IOException;

    public abstract String getPopulationFailure(StoreIndexDescriptor var1) throws IllegalStateException;

    public abstract InternalIndexState getInitialState(StoreIndexDescriptor var1);

    public abstract IndexCapability getCapability(StoreIndexDescriptor var1);

    public IndexProviderDescriptor getProviderDescriptor() {
        return this.providerDescriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexProvider other2 = (IndexProvider)o;
        return this.providerDescriptor.equals(other2.providerDescriptor);
    }

    public int hashCode() {
        return this.providerDescriptor.hashCode();
    }

    public IndexDirectoryStructure directoryStructure() {
        return this.directoryStructure;
    }

    public abstract StoreMigrationParticipant storeMigrationParticipant(FileSystemAbstraction var1, PageCache var2);

    public static interface Monitor {
        public static final Monitor EMPTY = new Adaptor();

        public void failedToOpenIndex(StoreIndexDescriptor var1, String var2, Exception var3);

        public void recoveryCleanupRegistered(File var1, IndexDescriptor var2);

        public void recoveryCleanupStarted(File var1, IndexDescriptor var2);

        public void recoveryCleanupFinished(File var1, IndexDescriptor var2, long var3, long var5, long var7);

        public void recoveryCleanupClosed(File var1, IndexDescriptor var2);

        public void recoveryCleanupFailed(File var1, IndexDescriptor var2, Throwable var3);

        public static class Adaptor
        implements Monitor {
            @Override
            public void failedToOpenIndex(StoreIndexDescriptor schemaIndexDescriptor, String action, Exception cause) {
            }

            @Override
            public void recoveryCleanupRegistered(File indexFile, IndexDescriptor indexDescriptor) {
            }

            @Override
            public void recoveryCleanupStarted(File indexFile, IndexDescriptor indexDescriptor) {
            }

            @Override
            public void recoveryCleanupFinished(File indexFile, IndexDescriptor indexDescriptor, long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
            }

            @Override
            public void recoveryCleanupClosed(File indexFile, IndexDescriptor indexDescriptor) {
            }

            @Override
            public void recoveryCleanupFailed(File indexFile, IndexDescriptor indexDescriptor, Throwable throwable) {
            }
        }
    }
}

