/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.labelscan;

import java.util.StringJoiner;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.logging.Log;

public class LoggingMonitor
extends LabelScanStore.Monitor.Adaptor {
    private final Log log;

    public LoggingMonitor(Log log) {
        this.log = log;
    }

    @Override
    public void noIndex() {
        this.log.info("No label index found, this might just be first use. Preparing to rebuild.");
    }

    @Override
    public void notValidIndex() {
        this.log.warn("Label index could not be read. Preparing to rebuild.");
    }

    @Override
    public void rebuilding() {
        this.log.info("Rebuilding label index, this may take a while");
    }

    @Override
    public void rebuilt(long roughNodeCount) {
        this.log.info("Label index rebuilt (roughly " + roughNodeCount + " nodes)");
    }

    @Override
    public void recoveryCleanupRegistered() {
        this.log.info("Label index cleanup job registered");
    }

    @Override
    public void recoveryCleanupStarted() {
        this.log.info("Label index cleanup job started");
    }

    @Override
    public void recoveryCleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
        StringJoiner joiner = new StringJoiner(", ", "Label index cleanup job finished: ", "");
        joiner.add("Number of pages visited: " + numberOfPagesVisited);
        joiner.add("Number of cleaned crashed pointers: " + numberOfCleanedCrashPointers);
        joiner.add("Time spent: " + Format.duration(durationMillis));
        this.log.info(joiner.toString());
    }

    @Override
    public void recoveryCleanupClosed() {
        this.log.info("Label index cleanup job closed");
    }

    @Override
    public void recoveryCleanupFailed(Throwable throwable) {
        this.log.info(String.format("Label index cleanup job failed.%nCaused by: %s", ExceptionUtils.getStackTrace(throwable)));
    }
}

