/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.proc;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.api.proc.Key;

public class BasicContext
implements Context {
    private final Map<String, Object> values = new HashMap<String, Object>();

    @Override
    public <T> T get(Key<T> key) throws ProcedureException {
        Object o = this.values.get(key.name());
        if (o == null) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "There is no `%s` in the current procedure call context.", key.name());
        }
        return (T)o;
    }

    @Override
    public <T> T getOrElse(Key<T> key, T orElse) {
        Object o = this.values.get(key.name());
        if (o == null) {
            return orElse;
        }
        return (T)o;
    }

    public <T> void put(Key<T> key, T value2) {
        this.values.put(key.name(), value2);
    }
}

