/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

public class MultiTokenSchemaDescriptor
implements SchemaDescriptor {
    private final int[] entityTokens;
    private final EntityType entityType;
    private final int[] propertyIds;

    MultiTokenSchemaDescriptor(int[] entityTokens, EntityType entityType, int[] propertyIds) {
        this.entityTokens = entityTokens;
        this.entityType = entityType;
        this.propertyIds = propertyIds;
    }

    @Override
    public boolean isAffected(long[] entityTokenIds) {
        for (int id2 : this.entityTokens) {
            if (!ArrayUtils.contains(entityTokenIds, (long)id2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> R computeWith(SchemaComputer<R> computer) {
        return computer.computeSpecific(this);
    }

    @Override
    public void processWith(SchemaProcessor processor) {
        processor.processSpecific(this);
    }

    public String toString() {
        return "MultiTokenSchemaDescriptor[" + this.userDescription(SchemaUtil.idTokenNameLookup) + "]";
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format((Object)((Object)this.entityType) + ":%s(%s)", String.join((CharSequence)", ", tokenNameLookup.entityTokensGetNames(this.entityType, this.entityTokens)), SchemaUtil.niceProperties(tokenNameLookup, this.propertyIds));
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    @Override
    public int[] getEntityTokenIds() {
        return this.entityTokens;
    }

    @Override
    public int keyId() {
        throw new UnsupportedOperationException(this + " does not have a single keyId.");
    }

    @Override
    public ResourceType keyType() {
        return this.entityType == EntityType.NODE ? ResourceTypes.LABEL : ResourceTypes.RELATIONSHIP_TYPE;
    }

    @Override
    public EntityType entityType() {
        return this.entityType;
    }

    @Override
    public SchemaDescriptor.PropertySchemaType propertySchemaType() {
        return SchemaDescriptor.PropertySchemaType.PARTIAL_ANY_TOKEN;
    }

    @Override
    public SchemaDescriptor schema() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SchemaDescriptor)) {
            return false;
        }
        SchemaDescriptor that = (SchemaDescriptor)o;
        return Arrays.equals(this.entityTokens, that.getEntityTokenIds()) && this.entityType == that.entityType() && Arrays.equals(this.propertyIds, that.getPropertyIds());
    }

    public int hashCode() {
        int result2 = Objects.hash(new Object[]{this.entityType});
        result2 = 31 * result2 + Arrays.hashCode(this.entityTokens);
        result2 = 31 * result2 + Arrays.hashCode(this.propertyIds);
        return result2;
    }
}

