/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.SchemaComputer;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaProcessor;
import org.neo4j.internal.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.lock.ResourceType;

public class RelationTypeSchemaDescriptor
implements org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor {
    private final int relTypeId;
    private final int[] propertyIds;

    RelationTypeSchemaDescriptor(int relTypeId, int ... propertyIds) {
        this.relTypeId = relTypeId;
        this.propertyIds = propertyIds;
    }

    @Override
    public boolean isAffected(long[] entityTokenIds) {
        return ArrayUtils.contains(entityTokenIds, (long)this.relTypeId);
    }

    @Override
    public <R> R computeWith(SchemaComputer<R> processor) {
        return processor.computeSpecific(this);
    }

    @Override
    public void processWith(SchemaProcessor processor) {
        processor.processSpecific(this);
    }

    @Override
    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("-[:%s(%s)]-", tokenNameLookup.relationshipTypeGetName(this.relTypeId), SchemaUtil.niceProperties(tokenNameLookup, this.propertyIds));
    }

    @Override
    public int getRelTypeId() {
        return this.relTypeId;
    }

    @Override
    public int[] getPropertyIds() {
        return this.propertyIds;
    }

    @Override
    public int[] getEntityTokenIds() {
        return new int[]{this.relTypeId};
    }

    @Override
    public int keyId() {
        return this.getRelTypeId();
    }

    @Override
    public ResourceType keyType() {
        return ResourceTypes.RELATIONSHIP_TYPE;
    }

    @Override
    public EntityType entityType() {
        return EntityType.RELATIONSHIP;
    }

    @Override
    public SchemaDescriptor.PropertySchemaType propertySchemaType() {
        return SchemaDescriptor.PropertySchemaType.COMPLETE_ALL_TOKENS;
    }

    public boolean equals(Object o) {
        if (o instanceof RelationTypeSchemaDescriptor) {
            RelationTypeSchemaDescriptor that = (RelationTypeSchemaDescriptor)o;
            return this.relTypeId == that.getRelTypeId() && Arrays.equals(this.propertyIds, that.getPropertyIds());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.propertyIds) + 31 * this.relTypeId;
    }

    @Override
    public SchemaDescriptor schema() {
        return this;
    }
}

