/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.constraints;

import org.neo4j.internal.kernel.api.TokenNameLookup;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptor;

public class RelExistenceConstraintDescriptor
extends ConstraintDescriptor {
    private final RelationTypeSchemaDescriptor schema;

    RelExistenceConstraintDescriptor(RelationTypeSchemaDescriptor schema) {
        super(ConstraintDescriptor.Type.EXISTS);
        this.schema = schema;
    }

    @Override
    public RelationTypeSchemaDescriptor schema() {
        return this.schema;
    }

    @Override
    public String prettyPrint(TokenNameLookup tokenNameLookup) {
        String typeName = this.escapeLabelOrRelTyp(tokenNameLookup.relationshipTypeGetName(this.schema.getRelTypeId()));
        String relName = typeName.toLowerCase();
        String propertyName = tokenNameLookup.propertyKeyGetName(this.schema.getPropertyId());
        return String.format("CONSTRAINT ON ()-[ %s:%s ]-() ASSERT exists(%s.%s)", relName, typeName, relName, propertyName);
    }
}

