/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.txtracking;

import java.time.Duration;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;

public class TransactionIdTracker {
    private final Supplier<TransactionIdStore> transactionIdStoreSupplier;
    private final AvailabilityGuard databaseAvailabilityGuard;

    public TransactionIdTracker(Supplier<TransactionIdStore> transactionIdStoreSupplier, AvailabilityGuard databaseAvailabilityGuard) {
        this.databaseAvailabilityGuard = databaseAvailabilityGuard;
        this.transactionIdStoreSupplier = transactionIdStoreSupplier;
    }

    public void awaitUpToDate(long oldestAcceptableTxId, Duration timeout) throws TransactionFailureException {
        if (oldestAcceptableTxId <= 1L) {
            return;
        }
        if (!this.databaseAvailabilityGuard.isAvailable()) {
            throw new TransactionFailureException((Status)Status.General.DatabaseUnavailable, "Database unavailable", new Object[0]);
        }
        try {
            this.transactionIdStore().awaitClosedTransactionId(oldestAcceptableTxId, timeout.toMillis());
        }
        catch (InterruptedException | TimeoutException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new TransactionFailureException((Status)Status.Transaction.InstanceStateChanged, (Throwable)e, "Database not up to the requested version: %d. Latest database version is %d", oldestAcceptableTxId, this.transactionIdStore().getLastClosedTransactionId());
        }
    }

    private TransactionIdStore transactionIdStore() {
        return this.transactionIdStoreSupplier.get();
    }

    public long newestEncounteredTxId() {
        return this.transactionIdStore().getLastCommittedTransactionId();
    }
}

