/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.configuration.ExternalSettings;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.BaseSetting;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.internal.diagnostics.DiagnosticsPhase;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConfigLoadIOException;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.HttpConnectorValidator;
import org.neo4j.kernel.configuration.IndividualSettingsValidator;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class Config
implements DiagnosticsProvider,
Configuration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    private final List<ConfigOptions> configOptions;
    private final Map<String, String> params = new CopyOnWriteHashMap<String, String>();
    private final Map<String, Collection<BiConsumer<String, String>>> updateListeners = new ConcurrentHashMap<String, Collection<BiConsumer<String, String>>>();
    private final ConfigurationMigrator migrator;
    private final List<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();
    private final Map<String, String> overriddenDefaults = new CopyOnWriteHashMap<String, String>();
    private final Map<String, BaseSetting<?>> settingsMap;
    private Log log = new BufferingLog();

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder fromFile(@Nullable File configFile) {
        return Config.builder().withFile(configFile);
    }

    @Nonnull
    public static Builder fromFile(@Nonnull Path configFile) {
        return Config.builder().withFile(configFile);
    }

    @Nonnull
    public static Builder fromSettings(Map<String, String> initialSettings) {
        return Config.builder().withSettings(initialSettings);
    }

    @Nonnull
    public static Config defaults() {
        return Config.builder().build();
    }

    @Nonnull
    public static Config defaults(@Nonnull Map<String, String> initialSettings) {
        return Config.builder().withSettings(initialSettings).build();
    }

    @Nonnull
    public static Config defaults(@Nonnull Setting<?> setting, String value2) {
        return Config.builder().withSetting(setting, value2).build();
    }

    private Config(File configFile, boolean throwOnFileLoadFailure, Map<String, String> initialSettings, Map<String, String> overriddenDefaults, Collection<ConfigurationValidator> additionalValidators, List<LoadableConfig> settingsClasses) {
        boolean fromFile2;
        this.configOptions = settingsClasses.stream().map(LoadableConfig::getConfigOptions).flatMap(Collection::stream).collect(Collectors.toList());
        this.settingsMap = new HashMap();
        this.configOptions.stream().map(ConfigOptions::settingGroup).filter(BaseSetting.class::isInstance).map(BaseSetting.class::cast).forEach(setting -> this.settingsMap.put(setting.name(), (BaseSetting<?>)setting));
        this.validators.addAll(additionalValidators);
        this.migrator = new AnnotationBasedConfigurationMigrator(settingsClasses);
        this.overriddenDefaults.putAll(overriddenDefaults);
        boolean bl = fromFile2 = configFile != null;
        if (fromFile2) {
            Config.loadFromFile(configFile, this.log, throwOnFileLoadFailure, initialSettings);
        }
        overriddenDefaults.forEach(initialSettings::putIfAbsent);
        this.migrateAndValidateAndUpdateSettings(initialSettings, fromFile2);
        if (fromFile2) {
            this.warnAboutDeprecations(this.params);
        }
    }

    @Override
    public <T> T get(Setting<T> setting) {
        return (T)setting.apply(this.params::get);
    }

    public boolean isConfigured(Setting<?> setting) {
        return this.params.containsKey(setting.name());
    }

    public Set<String> identifiersFromGroup(Class<?> groupClass) {
        if (!groupClass.isAnnotationPresent(Group.class)) {
            throw new IllegalArgumentException("Class must be annotated with @Group");
        }
        String prefix = groupClass.getAnnotation(Group.class).value();
        Pattern pattern = Pattern.compile(Pattern.quote(prefix) + "\\.([^.]+)\\.(.+)");
        TreeSet<String> identifiers = new TreeSet<String>();
        for (String setting : this.params.keySet()) {
            Matcher matcher = pattern.matcher(setting);
            if (!matcher.matches()) continue;
            identifiers.add(matcher.group(1));
        }
        return identifiers;
    }

    public void augment(Map<String, String> settings) throws InvalidSettingException {
        this.migrateAndValidateAndUpdateSettings(settings, false);
    }

    public void augment(String setting, String value2) throws InvalidSettingException {
        this.augment(Collections.singletonMap(setting, value2));
    }

    public void augment(Setting<?> setting, String value2) {
        this.augment(setting.name(), value2);
    }

    public void augment(Config config) throws InvalidSettingException {
        this.augment(config.params);
    }

    public void augmentDefaults(Setting<?> setting, String value2) throws InvalidSettingException {
        this.overriddenDefaults.put(setting.name(), value2);
        this.params.putIfAbsent(setting.name(), value2);
    }

    public void setLogger(Log log) {
        if (this.log instanceof BufferingLog) {
            ((BufferingLog)this.log).replayInto(log);
        }
        this.log = log;
    }

    public Optional<String> getRaw(@Nonnull String key) {
        return Optional.ofNullable(this.params.get(key));
    }

    public Map<String, String> getRaw() {
        return new HashMap<String, String>(this.params);
    }

    public Optional<Object> getValue(@Nonnull String key) {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).filter(it -> it.name().equals(key)).map(ConfigValue::value).findFirst().orElseGet(Optional::empty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDynamicSetting(String setting, String update2, String origin) throws IllegalArgumentException, InvalidSettingException {
        this.verifyValidDynamicSetting(setting);
        Map<String, String> map2 = this.params;
        synchronized (map2) {
            String newValue;
            String oldValue;
            boolean oldValueIsDefault = false;
            boolean newValueIsDefault = false;
            if (update2 == null || update2.isEmpty()) {
                String overriddenDefault = this.overriddenDefaults.get(setting);
                boolean hasDefault = overriddenDefault != null;
                oldValue = hasDefault ? this.params.put(setting, overriddenDefault) : this.params.remove(setting);
                newValue = this.getDefaultValueOf(setting);
                newValueIsDefault = true;
            } else {
                Map<String, String> newEntry = MapUtil.stringMap(setting, update2);
                List settingValidators = this.configOptions.stream().map(ConfigOptions::settingGroup).collect(Collectors.toList());
                for (SettingValidator validator : settingValidators) {
                    validator.validate(newEntry, ignore -> {});
                }
                String previousValue = this.params.put(setting, update2);
                if (previousValue != null) {
                    oldValue = previousValue;
                } else {
                    oldValue = this.getDefaultValueOf(setting);
                    oldValueIsDefault = true;
                }
                newValue = update2;
            }
            String oldValueForLog = this.obsfucateIfSecret(setting, oldValue);
            String newValueForLog = this.obsfucateIfSecret(setting, newValue);
            this.log.info("Setting changed: '%s' changed from '%s' to '%s' via '%s'", setting, oldValueIsDefault ? "default (" + oldValueForLog + ")" : oldValueForLog, newValueIsDefault ? "default (" + newValueForLog + ")" : newValueForLog, origin);
            ((Collection)this.updateListeners.getOrDefault(setting, Collections.emptyList())).forEach(l -> l.accept(oldValue, newValue));
        }
    }

    private void verifyValidDynamicSetting(String setting) {
        Optional<ConfigValue> option = this.findConfigValue(setting);
        if (!option.isPresent()) {
            throw new IllegalArgumentException("Unknown setting: " + setting);
        }
        ConfigValue configValue = option.get();
        if (!configValue.dynamic()) {
            throw new IllegalArgumentException("Setting is not dynamic and can not be changed at runtime");
        }
    }

    private String getDefaultValueOf(String setting) {
        if (this.overriddenDefaults.containsKey(setting)) {
            return this.overriddenDefaults.get(setting);
        }
        if (this.settingsMap.containsKey(setting)) {
            return this.settingsMap.get(setting).getDefaultValue();
        }
        return "<no default>";
    }

    private Optional<ConfigValue> findConfigValue(String setting) {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).filter(it -> it.name().equals(setting)).findFirst();
    }

    public <V> void registerDynamicUpdateListener(Setting<V> setting, BiConsumer<V, V> listener) {
        String settingName = setting.name();
        this.verifyValidDynamicSetting(settingName);
        BiConsumer<String, String> projectedListener = (oldValStr, newValStr) -> {
            try {
                Object oldVal = setting.apply(s2 -> oldValStr);
                Object newVal = setting.apply(s2 -> newValStr);
                listener.accept(oldVal, newVal);
            }
            catch (Exception e) {
                this.log.error("Failure when notifying listeners after dynamic setting change; new setting might not have taken effect: " + e.getMessage(), e);
            }
        };
        this.updateListeners.computeIfAbsent(settingName, k -> new ConcurrentLinkedQueue()).add(projectedListener);
    }

    public Map<String, ConfigValue> getConfigValues() {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).collect(Collectors.toMap(ConfigValue::name, it -> it, (val1, val2) -> {
            throw new RuntimeException("Duplicate setting: " + val1.name() + ": " + val1 + " and " + val2);
        }));
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger logger) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            logger.log("Neo4j Kernel properties:");
            for (Map.Entry<String, String> param2 : this.params.entrySet()) {
                logger.log("%s=%s", param2.getKey(), this.obsfucateIfSecret(param2));
            }
        }
    }

    private String obsfucateIfSecret(Map.Entry<String, String> param2) {
        return this.obsfucateIfSecret(param2.getKey(), param2.getValue());
    }

    private String obsfucateIfSecret(String key, String value2) {
        if (this.settingsMap.containsKey(key) && this.settingsMap.get(key).secret()) {
            return "##########";
        }
        return value2;
    }

    private void migrateAndValidateAndUpdateSettings(Map<String, String> settings, boolean warnOnUnknownSettings) throws InvalidSettingException {
        Map<String, String> migratedSettings = this.migrateSettings(settings);
        this.params.putAll(migratedSettings);
        List<SettingValidator> settingValidators = this.configOptions.stream().map(ConfigOptions::settingGroup).collect(Collectors.toList());
        Map<String, String> additionalSettings = new IndividualSettingsValidator(settingValidators, warnOnUnknownSettings).validate(this, this.log);
        this.params.putAll(additionalSettings);
        for (ConfigurationValidator validator : this.validators) {
            validator.validate(this, this.log);
        }
    }

    private Map<String, String> migrateSettings(Map<String, String> settings) {
        return this.migrator.apply(settings, this.log);
    }

    private void warnAboutDeprecations(Map<String, String> userSettings) {
        this.configOptions.stream().flatMap(it -> it.asConfigValues(userSettings).stream()).filter(config -> userSettings.containsKey(config.name()) && config.deprecated()).forEach(c -> {
            if (c.replacement().isPresent()) {
                this.log.warn("%s is deprecated. Replaced by %s", c.name(), c.replacement().get());
            } else {
                this.log.warn("%s is deprecated.", c.name());
            }
        });
    }

    @Nonnull
    private static void loadFromFile(@Nonnull File file, final @Nonnull Log log, boolean throwOnFileLoadFailure, final Map<String, String> into) {
        if (!file.exists()) {
            if (throwOnFileLoadFailure) {
                throw new ConfigLoadIOException(new IOException("Config file [" + file + "] does not exist."));
            }
            log.warn("Config file [%s] does not exist.", file);
            return;
        }
        try {
            Properties loader = new Properties(){

                @Override
                public Object put(Object key, Object val) {
                    String value2;
                    String setting = key.toString();
                    if (into.putIfAbsent(setting, value2 = val.toString()) != null && super.put(key, val) == null && !key.equals(ExternalSettings.additionalJvm.name())) {
                        log.warn("The '%s' setting is specified more than once. Settings only be specified once, to avoid ambiguity. The setting value that will be used is '%s'.", setting, into.get(setting));
                    }
                    return null;
                }
            };
            try (FileInputStream stream = new FileInputStream(file);){
                loader.load(stream);
            }
        }
        catch (IOException e) {
            if (throwOnFileLoadFailure) {
                throw new ConfigLoadIOException("Unable to load config file [" + file + "].", e);
            }
            log.error("Unable to load config file [%s]: %s", file, e.getMessage());
        }
    }

    @Nonnull
    public Set<String> allConnectorIdentifiers() {
        return this.allConnectorIdentifiers(this.params);
    }

    @Nonnull
    public Set<String> allConnectorIdentifiers(@Nonnull Map<String, String> params2) {
        return this.identifiersFromGroup(Connector.class);
    }

    @Nonnull
    public List<BoltConnector> boltConnectors() {
        return this.boltConnectors(this.params).collect(Collectors.toList());
    }

    @Nonnull
    private Stream<BoltConnector> boltConnectors(@Nonnull Map<String, String> params2) {
        return this.allConnectorIdentifiers(params2).stream().map(BoltConnector::new).filter(c -> {
            if (c.group.groupKey.equalsIgnoreCase("bolt")) return true;
            if (Connector.ConnectorType.BOLT != c.type.apply(params2::get)) return false;
            return true;
        });
    }

    @Nonnull
    public List<BoltConnector> enabledBoltConnectors() {
        return this.enabledBoltConnectors(this.params);
    }

    @Nonnull
    public List<BoltConnector> enabledBoltConnectors(@Nonnull Map<String, String> params2) {
        return this.boltConnectors(params2).filter(c -> (Boolean)c.enabled.apply(params2::get)).collect(Collectors.toList());
    }

    @Nonnull
    public List<HttpConnector> httpConnectors() {
        return this.httpConnectors(this.params).collect(Collectors.toList());
    }

    @Nonnull
    private Stream<HttpConnector> httpConnectors(@Nonnull Map<String, String> params2) {
        return this.allConnectorIdentifiers(params2).stream().map(Connector::new).filter(c -> {
            if (c.group.groupKey.equalsIgnoreCase("http")) return true;
            if (c.group.groupKey.equalsIgnoreCase("https")) return true;
            if (Connector.ConnectorType.HTTP != c.type.apply((Connector.ConnectorType)((Object)((Object)((Function<String, String>)params2::get))))) return false;
            return true;
        }).map(c -> {
            HttpConnector.Encryption defaultEncryption;
            String name;
            switch (name = c.group.groupKey) {
                case "https": {
                    defaultEncryption = HttpConnector.Encryption.TLS;
                    break;
                }
                default: {
                    defaultEncryption = HttpConnector.Encryption.NONE;
                }
            }
            return new HttpConnector(name, (HttpConnector.Encryption)((Object)((Object)HttpConnectorValidator.encryptionSetting(name, defaultEncryption).apply((HttpConnector.Encryption)((Object)((Object)((Function<String, String>)params2::get)))))));
        });
    }

    @Nonnull
    public List<HttpConnector> enabledHttpConnectors() {
        return this.enabledHttpConnectors(this.params);
    }

    @Nonnull
    private List<HttpConnector> enabledHttpConnectors(@Nonnull Map<String, String> params2) {
        return this.httpConnectors(params2).filter(c -> (Boolean)c.enabled.apply(params2::get)).collect(Collectors.toList());
    }

    public String toString() {
        return this.params.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (String)entry.getKey() + "=" + this.obsfucateIfSecret((Map.Entry<String, String>)entry)).collect(Collectors.joining(", "));
    }

    public static class Builder {
        private Map<String, String> initialSettings = MapUtil.stringMap(new String[0]);
        private Map<String, String> overriddenDefaults = MapUtil.stringMap(new String[0]);
        private List<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();
        private File configFile;
        private List<LoadableConfig> settingsClasses;
        private boolean connectorsDisabled;
        private boolean throwOnFileLoadFailure = true;

        public Builder withSetting(Setting<?> setting, String value2) {
            return this.withSetting(setting.name(), value2);
        }

        public Builder withSetting(String setting, String value2) {
            this.initialSettings.put(setting, value2);
            return this;
        }

        public Builder withSettings(Map<String, String> initialSettings) {
            this.initialSettings.putAll(initialSettings);
            return this;
        }

        @Nonnull
        public Builder withConfigClasses(Collection<? extends LoadableConfig> loadableConfigs) {
            if (this.settingsClasses == null) {
                this.settingsClasses = new ArrayList<LoadableConfig>();
            }
            this.settingsClasses.addAll(loadableConfigs);
            return this;
        }

        @Nonnull
        public Builder withValidator(ConfigurationValidator validator) {
            this.validators.add(validator);
            return this;
        }

        @Nonnull
        public Builder withValidators(Collection<ConfigurationValidator> validators) {
            this.validators.addAll(validators);
            return this;
        }

        @Nonnull
        public Builder withServerDefaults() {
            HttpConnector http = new HttpConnector("http", HttpConnector.Encryption.NONE);
            HttpConnector https = new HttpConnector("https", HttpConnector.Encryption.TLS);
            BoltConnector bolt = new BoltConnector("bolt");
            this.overriddenDefaults.put(GraphDatabaseSettings.auth_enabled.name(), "true");
            this.overriddenDefaults.put(http.enabled.name(), "true");
            this.overriddenDefaults.put(https.enabled.name(), "true");
            this.overriddenDefaults.put(bolt.enabled.name(), "true");
            return this;
        }

        @Nonnull
        public Builder withFile(@Nullable File configFile) {
            this.configFile = configFile;
            return this;
        }

        @Nonnull
        public Builder withFile(Path configFile) {
            return this.withFile(configFile.toFile());
        }

        @Nonnull
        public Builder withFile(Optional<File> configFile) {
            configFile.ifPresent(file -> {
                this.configFile = file;
            });
            return this;
        }

        @Nonnull
        public Builder withHome(File homeDir) {
            this.initialSettings.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
            return this;
        }

        @Nonnull
        public Builder withHome(Path homeDir) {
            return this.withHome(homeDir.toFile());
        }

        @Nonnull
        public Builder withConnectorsDisabled() {
            this.connectorsDisabled = true;
            return this;
        }

        public Builder withNoThrowOnFileLoadFailure() {
            this.throwOnFileLoadFailure = false;
            return this;
        }

        @Nonnull
        public Config build() throws InvalidSettingException {
            List loadableConfigs = Optional.ofNullable(this.settingsClasses).orElseGet(LoadableConfig::allConfigClasses);
            if (this.configFile != null && !this.initialSettings.containsKey(GraphDatabaseSettings.neo4j_home.name())) {
                this.initialSettings.put(GraphDatabaseSettings.neo4j_home.name(), System.getProperty("user.dir"));
            }
            Config config = new Config(this.configFile, this.throwOnFileLoadFailure, this.initialSettings, this.overriddenDefaults, this.validators, loadableConfigs);
            if (this.connectorsDisabled) {
                config.augment(config.allConnectorIdentifiers().stream().collect(Collectors.toMap(id2 -> new Connector((String)id2).enabled.name(), id2 -> "false")));
            }
            return config;
        }
    }
}

