/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.configuration.BaseConfigurationMigrator;
import org.neo4j.kernel.configuration.Settings;

public class GraphDatabaseConfigurationMigrator
extends BaseConfigurationMigrator {
    public GraphDatabaseConfigurationMigrator() {
        this.registerMigrations();
    }

    private void registerMigrations() {
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("dbms.index_sampling.buffer_size", "dbms.index_sampling.buffer_size has been replaced with dbms.index_sampling.sample_size_limit."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                if (StringUtils.isNotEmpty(value2)) {
                    String oldSettingDefaultValue = GraphDatabaseSettings.index_sampling_buffer_size.getDefaultValue();
                    Long newValue = oldSettingDefaultValue.equals(value2) ? Long.valueOf(ByteUnit.mebiBytes(8L)) : Settings.BYTES.apply(value2);
                    rawConfiguration.put("dbms.index_sampling.sample_size_limit", String.valueOf(newValue));
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("dbms.transaction_timeout", "dbms.transaction_timeout has been replaced with dbms.rest.transaction.idle_timeout."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                rawConfiguration.put("dbms.rest.transaction.idle_timeout", value2);
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("unsupported.dbms.executiontime_limit.enabled", "unsupported.dbms.executiontime_limit.enabled is not supported anymore. Set dbms.transaction.timeout settings to some positive value to enable execution guard and set transaction timeout."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("unsupported.dbms.executiontime_limit.time", "unsupported.dbms.executiontime_limit.time has been replaced with dbms.transaction.timeout."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                if (StringUtils.isNotEmpty(value2)) {
                    rawConfiguration.putIfAbsent(GraphDatabaseSettings.transaction_timeout.name(), value2);
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("unsupported.dbms.shutdown_transaction_end_timeout", "unsupported.dbms.shutdown_transaction_end_timeout has been replaced with dbms.shutdown_transaction_end_timeout."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                if (StringUtils.isNotEmpty(value2)) {
                    rawConfiguration.putIfAbsent(GraphDatabaseSettings.shutdown_transaction_end_timeout.name(), value2);
                }
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("dbms.allow_format_migration", "dbms.allow_format_migration has been replaced with dbms.allow_upgrade."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                rawConfiguration.put(GraphDatabaseSettings.allow_upgrade.name(), value2);
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("dbms.logs.timezone", "dbms.logs.timezone has been replaced with dbms.db.timezone."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                rawConfiguration.put(GraphDatabaseSettings.db_timezone.name(), value2);
            }
        });
        this.add(new BaseConfigurationMigrator.SpecificPropertyMigration("unsupported.dbms.enable_native_schema_index", "unsupported.dbms.enable_native_schema_index has been replaced with dbms.index.default_schema_provider."){

            @Override
            public void setValueWithOldSetting(String value2, Map<String, String> rawConfiguration) {
                if (value2.equals("false")) {
                    rawConfiguration.putIfAbsent(GraphDatabaseSettings.default_schema_provider.name(), GraphDatabaseSettings.SchemaIndex.LUCENE10.providerName());
                }
            }
        });
    }
}

