/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.neo4j.kernel.extension.KernelExtensionFactory;

public abstract class KernelExtensionUtil {
    private KernelExtensionUtil() {
        throw new AssertionError();
    }

    public static String servicesClassPathEntryInformation() {
        String separator = System.lineSeparator();
        StringBuilder result2 = new StringBuilder("Kernel extensions available on classpath: ");
        StringBuilder classPath = new StringBuilder();
        for (String entry : System.getProperty("java.class.path").split(File.pathSeparator)) {
            File extensionsFile;
            File servicesDir;
            classPath.append(separator).append("  ").append(entry);
            File entryFile = new File(entry);
            if (!entryFile.isDirectory() || !(servicesDir = new File(new File(entryFile, "META-INF"), "services")).exists()) continue;
            result2.append(separator).append("Listing service files and kernel extensions where possible in ").append(servicesDir).append(':');
            File[] files2 = servicesDir.listFiles();
            if (files2 != null) {
                for (File serviceFile : files2) {
                    if (!serviceFile.isFile()) continue;
                    result2.append(separator).append("  ").append(serviceFile.getName());
                }
            }
            if (!(extensionsFile = new File(servicesDir, KernelExtensionFactory.class.getName())).exists()) continue;
            KernelExtensionUtil.appendKernelExtensionsList(extensionsFile, result2, separator + "   + ");
        }
        return result2.append(separator).append(separator).append("Class path entries:").append((CharSequence)classPath).toString();
    }

    private static void appendKernelExtensionsList(File file, StringBuilder to2, String separator) {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                boolean exists2 = KernelExtensionUtil.tryLoadClass(line);
                to2.append(separator).append(line).append(" (").append(exists2 ? "exists" : "DOES NOT exist").append(')');
            }
        }
        catch (IOException e) {
            to2.append("Couldn't read due to ").append(e.getMessage());
        }
    }

    private static boolean tryLoadClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

