/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

public interface CountsVisitor {
    public void visitNodeCount(int var1, long var2);

    public void visitRelationshipCount(int var1, int var2, int var3, long var4);

    public void visitIndexStatistics(long var1, long var3, long var5);

    public void visitIndexSample(long var1, long var3, long var5);

    public static class Adapter
    implements CountsVisitor {
        @Override
        public void visitNodeCount(int labelId, long count2) {
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count2) {
        }

        @Override
        public void visitIndexStatistics(long indexId, long updates, long size2) {
        }

        @Override
        public void visitIndexSample(long indexId, long unique, long size2) {
        }

        public static CountsVisitor multiplex(final CountsVisitor ... visitors) {
            return new CountsVisitor(){

                @Override
                public void visitNodeCount(int labelId, long count2) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitNodeCount(labelId, count2);
                    }
                }

                @Override
                public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count2) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitRelationshipCount(startLabelId, typeId, endLabelId, count2);
                    }
                }

                @Override
                public void visitIndexStatistics(long indexId, long updates, long size2) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitIndexStatistics(indexId, updates, size2);
                    }
                }

                @Override
                public void visitIndexSample(long indexId, long unique, long size2) {
                    for (CountsVisitor visitor : visitors) {
                        visitor.visitIndexSample(indexId, unique, size2);
                    }
                }
            };
        }
    }

    public static interface Visitable {
        public void accept(CountsVisitor var1);
    }
}

