/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.api.ExplicitIndexProvider;
import org.neo4j.kernel.spi.explicitindex.IndexImplementation;
import org.neo4j.kernel.spi.explicitindex.IndexProviders;

public class DefaultExplicitIndexProvider
implements IndexProviders,
ExplicitIndexProvider {
    private final Map<String, IndexImplementation> indexProviders = new HashMap<String, IndexImplementation>();

    @Override
    public void registerIndexProvider(String name, IndexImplementation index) {
        if (this.indexProviders.containsKey(name)) {
            throw new IllegalArgumentException("Index provider '" + name + "' already registered");
        }
        this.indexProviders.put(name, index);
    }

    @Override
    public boolean unregisterIndexProvider(String name) {
        IndexImplementation removed = this.indexProviders.remove(name);
        return removed != null;
    }

    @Override
    public IndexImplementation getProviderByName(String name) {
        IndexImplementation provider = this.indexProviders.get(name);
        if (provider == null) {
            throw new IllegalArgumentException("No index provider '" + name + "' found. Maybe the intended provider (or one more of its dependencies) aren't on the classpath or it failed to load.");
        }
        return provider;
    }

    @Override
    public Iterable<IndexImplementation> allIndexProviders() {
        return this.indexProviders.values();
    }
}

