/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.block.procedure.primitive.LongObjectProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;

public final class IndexMap
implements Cloneable {
    private final MutableLongObjectMap<IndexProxy> indexesById;
    private final Map<SchemaDescriptor, IndexProxy> indexesByDescriptor;
    private final MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> descriptorsByLabel;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> descriptorsByReltype;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> nodeDescriptorsByProperty;
    private final MutableIntObjectMap<Set<SchemaDescriptor>> relationshipDescriptorsByProperty;

    public IndexMap() {
        this(new LongObjectHashMap<IndexProxy>(), new HashMap<SchemaDescriptor, IndexProxy>(), new ObjectLongHashMap<SchemaDescriptor>());
    }

    IndexMap(MutableLongObjectMap<IndexProxy> indexesById) {
        this(indexesById, IndexMap.indexesByDescriptor(indexesById), IndexMap.indexIdsByDescriptor(indexesById));
    }

    private IndexMap(MutableLongObjectMap<IndexProxy> indexesById, Map<SchemaDescriptor, IndexProxy> indexesByDescriptor, MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor) {
        this.indexesById = indexesById;
        this.indexesByDescriptor = indexesByDescriptor;
        this.indexIdsByDescriptor = indexIdsByDescriptor;
        this.descriptorsByLabel = new IntObjectHashMap<Set<SchemaDescriptor>>();
        this.descriptorsByReltype = new IntObjectHashMap<Set<SchemaDescriptor>>();
        this.nodeDescriptorsByProperty = new IntObjectHashMap<Set<SchemaDescriptor>>();
        this.relationshipDescriptorsByProperty = new IntObjectHashMap<Set<SchemaDescriptor>>();
        for (SchemaDescriptor schema : indexesByDescriptor.keySet()) {
            this.addDescriptorToLookups(schema);
        }
    }

    public IndexProxy getIndexProxy(long indexId) {
        return (IndexProxy)this.indexesById.get(indexId);
    }

    public IndexProxy getIndexProxy(SchemaDescriptor descriptor) {
        return this.indexesByDescriptor.get(descriptor);
    }

    public long getIndexId(SchemaDescriptor descriptor) {
        return this.indexIdsByDescriptor.get(descriptor);
    }

    public void putIndexProxy(IndexProxy indexProxy) {
        CapableIndexDescriptor descriptor = indexProxy.getDescriptor();
        SchemaDescriptor schema = descriptor.schema();
        this.indexesById.put(descriptor.getId(), indexProxy);
        this.indexesByDescriptor.put(schema, indexProxy);
        this.indexIdsByDescriptor.put(schema, descriptor.getId());
        this.addDescriptorToLookups(schema);
    }

    public IndexProxy removeIndexProxy(long indexId) {
        IndexProxy removedProxy = this.indexesById.remove(indexId);
        if (removedProxy == null) {
            return null;
        }
        SchemaDescriptor schema = removedProxy.getDescriptor().schema();
        this.indexesByDescriptor.remove(schema);
        if (schema.entityType() == EntityType.NODE) {
            this.removeFromLookup(schema.getEntityTokenIds(), schema, this.descriptorsByLabel);
            this.removeFromLookup(schema.getPropertyIds(), schema, this.nodeDescriptorsByProperty);
        } else if (schema.entityType() == EntityType.RELATIONSHIP) {
            this.removeFromLookup(schema.getEntityTokenIds(), schema, this.descriptorsByReltype);
            this.removeFromLookup(schema.getPropertyIds(), schema, this.relationshipDescriptorsByProperty);
        }
        return removedProxy;
    }

    void forEachIndexProxy(LongObjectProcedure<IndexProxy> consumer) {
        this.indexesById.forEachKeyValue(consumer);
    }

    public Iterable<IndexProxy> getAllIndexProxies() {
        return this.indexesById.values();
    }

    public Set<SchemaDescriptor> getRelatedIndexes(long[] changedEntityTokens, long[] unchangedEntityTokens, IntSet properties, EntityType entityType) {
        switch (entityType) {
            case NODE: {
                return this.getRelatedDescriptors(changedEntityTokens, unchangedEntityTokens, properties, this.descriptorsByLabel, this.nodeDescriptorsByProperty);
            }
            case RELATIONSHIP: {
                return this.getRelatedDescriptors(changedEntityTokens, unchangedEntityTokens, properties, this.descriptorsByReltype, this.relationshipDescriptorsByProperty);
            }
        }
        throw new IllegalArgumentException("The given EntityType cannot be indexed: " + (Object)((Object)entityType));
    }

    public IndexMap clone() {
        return new IndexMap(LongObjectHashMap.newMap(this.indexesById), this.cloneMap(this.indexesByDescriptor), new ObjectLongHashMap<SchemaDescriptor>(this.indexIdsByDescriptor));
    }

    public Iterator<SchemaDescriptor> descriptors() {
        return this.indexesByDescriptor.keySet().iterator();
    }

    public LongIterator indexIds() {
        return this.indexesById.keySet().longIterator();
    }

    public int size() {
        return this.indexesById.size();
    }

    private <K, V> Map<K, V> cloneMap(Map<K, V> map2) {
        HashMap<K, V> shallowCopy = new HashMap<K, V>(map2.size());
        shallowCopy.putAll(map2);
        return shallowCopy;
    }

    private void addDescriptorToLookups(SchemaDescriptor schema) {
        block5: {
            block4: {
                if (schema.entityType() != EntityType.NODE) break block4;
                for (int entityTokenId : schema.getEntityTokenIds()) {
                    this.addToLookup(entityTokenId, schema, this.descriptorsByLabel);
                }
                for (int propertyId : schema.getPropertyIds()) {
                    this.addToLookup(propertyId, schema, this.nodeDescriptorsByProperty);
                }
                break block5;
            }
            if (schema.entityType() != EntityType.RELATIONSHIP) break block5;
            for (int entityTokenId : schema.getEntityTokenIds()) {
                this.addToLookup(entityTokenId, schema, this.descriptorsByReltype);
            }
            for (int propertyId : schema.getPropertyIds()) {
                this.addToLookup(propertyId, schema, this.relationshipDescriptorsByProperty);
            }
        }
    }

    private void addToLookup(int key, SchemaDescriptor schema, MutableIntObjectMap<Set<SchemaDescriptor>> lookup2) {
        HashSet<SchemaDescriptor> descriptors = (HashSet<SchemaDescriptor>)lookup2.get(key);
        if (descriptors == null) {
            descriptors = new HashSet<SchemaDescriptor>();
            lookup2.put(key, descriptors);
        }
        descriptors.add(schema);
    }

    private void removeFromLookup(int[] keys, SchemaDescriptor schema, MutableIntObjectMap<Set<SchemaDescriptor>> lookup2) {
        for (int key : keys) {
            Set descriptors = (Set)lookup2.get(key);
            descriptors.remove(schema);
            if (!descriptors.isEmpty()) continue;
            lookup2.remove(key);
        }
    }

    private static Map<SchemaDescriptor, IndexProxy> indexesByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        return indexesById.toMap(indexProxy -> indexProxy.getDescriptor().schema(), Functions.identity());
    }

    private static MutableObjectLongMap<SchemaDescriptor> indexIdsByDescriptor(LongObjectMap<IndexProxy> indexesById) {
        ObjectLongHashMap<SchemaDescriptor> map2 = new ObjectLongHashMap<SchemaDescriptor>(indexesById.size());
        indexesById.forEachKeyValue((id2, indexProxy) -> map2.put(indexProxy.getDescriptor().schema(), id2));
        return map2;
    }

    private Set<SchemaDescriptor> getRelatedDescriptors(long[] changedEntityTokens, long[] unchangedEntityTokens, IntSet properties, IntObjectMap<Set<SchemaDescriptor>> descriptorsByEntityToken, IntObjectMap<Set<SchemaDescriptor>> descriptorsByProperty) {
        Set<SchemaDescriptor> indexesByProperties = this.extractIndexesByProperties(properties, descriptorsByProperty);
        Set<SchemaDescriptor> indexesByUnchangedEntityTokens = this.extractIndexesByEntityTokens(unchangedEntityTokens, descriptorsByEntityToken);
        indexesByProperties.retainAll(indexesByUnchangedEntityTokens);
        Set<SchemaDescriptor> descriptors = this.extractIndexesByEntityTokens(changedEntityTokens, descriptorsByEntityToken);
        descriptors.addAll(indexesByProperties);
        return descriptors;
    }

    private Set<SchemaDescriptor> extractIndexesByEntityTokens(long[] entityTokenIds, IntObjectMap<Set<SchemaDescriptor>> descriptors) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        for (long label : entityTokenIds) {
            Set<SchemaDescriptor> forLabel = descriptors.get((int)label);
            if (forLabel == null) continue;
            set.addAll(forLabel);
        }
        return set;
    }

    private Set<SchemaDescriptor> extractIndexesByProperties(IntSet properties, IntObjectMap<Set<SchemaDescriptor>> descriptorsByProperty) {
        HashSet<SchemaDescriptor> set = new HashSet<SchemaDescriptor>();
        IntIterator iterator2 = properties.intIterator();
        while (iterator2.hasNext()) {
            Set<SchemaDescriptor> forProperty = descriptorsByProperty.get(iterator2.next());
            if (forProperty == null) continue;
            set.addAll(forProperty);
        }
        return set;
    }
}

