/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.time.Clock;
import java.util.EnumMap;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.TimeUtil;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.logging.Log;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.VisibleForTesting;

public class LoggingPhaseTracker
implements PhaseTracker {
    private static final String MESSAGE_PREFIX = "TIME/PHASE ";
    static final int PERIOD_INTERVAL = FeatureToggles.getInteger(LoggingPhaseTracker.class, "period_interval", 600);
    private final long periodInterval;
    private final Log log;
    private final Clock clock;
    private EnumMap<PhaseTracker.Phase, Logger> times = new EnumMap(PhaseTracker.Phase.class);
    private PhaseTracker.Phase currentPhase;
    private long timeEnterPhase;
    private boolean stopped;
    private long lastPeriodReport = -1L;

    LoggingPhaseTracker(Log log) {
        this(PERIOD_INTERVAL, log, Clock.systemUTC());
    }

    @VisibleForTesting
    LoggingPhaseTracker(long periodIntervalInSeconds, Log log, Clock clock) {
        this.periodInterval = TimeUnit.SECONDS.toMillis(periodIntervalInSeconds);
        this.log = log;
        this.clock = clock;
        for (PhaseTracker.Phase phase : PhaseTracker.Phase.values()) {
            this.times.put(phase, new Logger(phase));
        }
    }

    @Override
    public void enterPhase(PhaseTracker.Phase phase) {
        if (this.stopped) {
            throw new IllegalStateException("Trying to report a new phase after phase tracker has been stopped.");
        }
        if (phase != this.currentPhase) {
            long millisSinceLastPeriodReport;
            long now = this.logCurrentTime();
            this.currentPhase = phase;
            this.timeEnterPhase = now;
            if (this.lastPeriodReport == -1L) {
                this.lastPeriodReport = now;
            }
            if ((millisSinceLastPeriodReport = now - this.lastPeriodReport) >= this.periodInterval) {
                this.periodReport(millisSinceLastPeriodReport);
                this.lastPeriodReport = now;
            }
        }
    }

    @Override
    public void stop() {
        this.stopped = true;
        this.logCurrentTime();
        this.currentPhase = null;
        this.finalReport();
    }

    EnumMap<PhaseTracker.Phase, Logger> times() {
        return this.times;
    }

    private void finalReport() {
        this.log.info(MESSAGE_PREFIX + this.mainReportString("Final"));
    }

    private void periodReport(long millisSinceLastPerioReport) {
        String periodReportString = this.periodReportString(millisSinceLastPerioReport);
        String mainReportString = this.mainReportString("Total");
        this.log.debug(MESSAGE_PREFIX + mainReportString + ", " + periodReportString);
    }

    private String mainReportString(String title) {
        StringJoiner joiner = new StringJoiner(", ", title + ": ", "");
        this.times.values().forEach(logger -> this.reportToJoiner(joiner, (Counter)logger));
        return joiner.toString();
    }

    private String periodReportString(long millisSinceLastPeriodReport) {
        long secondsSinceLastPeriodReport = TimeUnit.MILLISECONDS.toSeconds(millisSinceLastPeriodReport);
        StringJoiner joiner = new StringJoiner(", ", "Last " + secondsSinceLastPeriodReport + " sec: ", "");
        this.times.values().stream().map(Logger::period).forEach(period -> {
            this.reportToJoiner(joiner, (Counter)period);
            period.reset();
        });
        return joiner.toString();
    }

    private void reportToJoiner(StringJoiner joiner, Counter counter) {
        if (counter.nbrOfReports > 0L) {
            joiner.add(counter.toString());
        }
    }

    private long logCurrentTime() {
        long now = this.clock.millis();
        if (this.currentPhase != null) {
            Logger logger = this.times.get((Object)this.currentPhase);
            long timeMillis = now - this.timeEnterPhase;
            logger.log(timeMillis);
        }
        return now;
    }

    public class Counter {
        private final PhaseTracker.Phase phase;
        long totalTime;
        long nbrOfReports;
        long maxTime;
        long minTime;

        Counter(PhaseTracker.Phase phase) {
            this.phase = phase;
        }

        void log(long timeMillis) {
            this.totalTime += timeMillis;
            ++this.nbrOfReports;
            this.maxTime = Math.max(this.maxTime, timeMillis);
            this.minTime = Math.min(this.minTime, timeMillis);
        }

        void reset() {
            this.totalTime = 0L;
            this.nbrOfReports = 0L;
            this.maxTime = Long.MIN_VALUE;
            this.minTime = Long.MAX_VALUE;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", this.phase.toString() + "[", "]");
            if (this.nbrOfReports == 0L) {
                this.addToString("nbrOfReports", this.nbrOfReports, joiner, false);
            } else if (this.nbrOfReports == 1L) {
                this.addToString("totalTime", this.totalTime, joiner, true);
            } else {
                long avgTime = this.totalTime / this.nbrOfReports;
                this.addToString("totalTime", this.totalTime, joiner, true);
                this.addToString("avgTime", avgTime, joiner, true);
                this.addToString("minTime", this.minTime, joiner, true);
                this.addToString("maxTime", this.maxTime, joiner, true);
                this.addToString("nbrOfReports", this.nbrOfReports, joiner, false);
            }
            return joiner.toString();
        }

        void addToString(String name, long measurement, StringJoiner joiner, boolean isTime) {
            String measurementString;
            if (isTime) {
                long timeInNanos = TimeUnit.MILLISECONDS.toNanos(measurement);
                measurementString = TimeUtil.nanosToString(timeInNanos);
            } else {
                measurementString = Long.toString(measurement);
            }
            joiner.add(String.format("%s=%s", name, measurementString));
        }
    }

    public class Logger
    extends Counter {
        final Counter periodCounter;

        private Logger(PhaseTracker.Phase phase) {
            super(phase);
            this.periodCounter = new Counter(phase);
            this.periodCounter.reset();
        }

        @Override
        void log(long timeMillis) {
            super.log(timeMillis);
            this.periodCounter.log(timeMillis);
        }

        Counter period() {
            return this.periodCounter;
        }
    }
}

