/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.storageengine.api.schema.CapableIndexDescriptor;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.values.storable.Value;

public class PopulatingIndexProxy
implements IndexProxy {
    private final CapableIndexDescriptor capableIndexDescriptor;
    private final IndexPopulationJob job;
    private final MultipleIndexPopulator.IndexPopulation indexPopulation;

    PopulatingIndexProxy(CapableIndexDescriptor capableIndexDescriptor, IndexPopulationJob job, MultipleIndexPopulator.IndexPopulation indexPopulation) {
        this.capableIndexDescriptor = capableIndexDescriptor;
        this.job = job;
        this.indexPopulation = indexPopulation;
    }

    @Override
    public void start() {
    }

    @Override
    public IndexUpdater newUpdater(final IndexUpdateMode mode) {
        switch (mode) {
            case ONLINE: 
            case RECOVERY: {
                return new PopulatingIndexUpdater(){

                    @Override
                    public void process(IndexEntryUpdate<?> update2) {
                        PopulatingIndexProxy.this.job.update(update2);
                    }
                };
            }
        }
        return new PopulatingIndexUpdater(){

            @Override
            public void process(IndexEntryUpdate<?> update2) {
                throw new IllegalArgumentException("Unsupported update mode: " + (Object)((Object)mode));
            }
        };
    }

    @Override
    public void drop() {
        this.job.dropPopulation(this.indexPopulation);
    }

    @Override
    public CapableIndexDescriptor getDescriptor() {
        return this.capableIndexDescriptor;
    }

    @Override
    public InternalIndexState getState() {
        return InternalIndexState.POPULATING;
    }

    @Override
    public void force(IOLimiter ioLimiter) {
    }

    @Override
    public void refresh() {
    }

    @Override
    public void close() {
        this.job.cancelPopulation(this.indexPopulation);
    }

    @Override
    public IndexReader newReader() throws IndexNotFoundKernelException {
        throw new IndexNotFoundKernelException("Index is still populating: " + this.job);
    }

    @Override
    public boolean awaitStoreScanCompleted(long time, TimeUnit unit) throws InterruptedException {
        return this.job.awaitCompletion(time, unit);
    }

    @Override
    public void activate() {
        throw new IllegalStateException("Cannot activate index while it is still populating: " + this.job);
    }

    @Override
    public void validate() {
        throw new IllegalStateException("Cannot validate index while it is still populating: " + this.job);
    }

    @Override
    public void validateBeforeCommit(Value[] tuple) {
    }

    @Override
    public ResourceIterator<File> snapshotFiles() {
        return Iterators.emptyResourceIterator();
    }

    @Override
    public IndexPopulationFailure getPopulationFailure() throws IllegalStateException {
        throw new IllegalStateException(this + " is POPULATING");
    }

    @Override
    public PopulationProgress getIndexPopulationProgress() {
        return this.job.getPopulationProgress(this.indexPopulation);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[job:" + this.job + "]";
    }

    private abstract class PopulatingIndexUpdater
    implements IndexUpdater {
        private PopulatingIndexUpdater() {
        }

        @Override
        public void close() {
        }
    }
}

