/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.neo4j.kernel.impl.api.BatchTransactionApplier;
import org.neo4j.kernel.impl.api.TransactionApplier;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.CommandsToApply;

public class PropertyCommandsExtractor
extends TransactionApplier.Adapter
implements BatchTransactionApplier {
    private final MutableLongObjectMap<Command.NodeCommand> nodeCommandsById = new LongObjectHashMap<Command.NodeCommand>();
    private final MutableLongObjectMap<Command.RelationshipCommand> relationshipCommandsById = new LongObjectHashMap<Command.RelationshipCommand>();
    private final MutableLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds = new LongObjectHashMap<List<Command.PropertyCommand>>();
    private final MutableLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByRelationshipIds = new LongObjectHashMap<List<Command.PropertyCommand>>();
    private boolean hasUpdates;

    @Override
    public TransactionApplier startTx(CommandsToApply transaction) {
        return this;
    }

    @Override
    public TransactionApplier startTx(CommandsToApply transaction, LockGroup lockGroup) {
        return this.startTx(transaction);
    }

    @Override
    public void close() {
        this.nodeCommandsById.clear();
        this.relationshipCommandsById.clear();
        this.propertyCommandsByNodeIds.clear();
        this.propertyCommandsByRelationshipIds.clear();
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.nodeCommandsById.put(command.getKey(), command);
        if (!this.hasUpdates && PropertyCommandsExtractor.mayResultInIndexUpdates(command)) {
            this.hasUpdates = true;
        }
        return false;
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.relationshipCommandsById.put(command.getKey(), command);
        this.hasUpdates = true;
        return false;
    }

    private static boolean mayResultInIndexUpdates(Command.NodeCommand command) {
        long after;
        long before = ((NodeRecord)command.getBefore()).getLabelField();
        return before != (after = ((NodeRecord)command.getAfter()).getLabelField()) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(before) || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(after);
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        if (((PropertyRecord)command.getAfter()).isNodeSet()) {
            this.createOrAddToGroup(command, ((PropertyRecord)command.getAfter()).getNodeId(), this.propertyCommandsByNodeIds);
        } else if (((PropertyRecord)command.getAfter()).isRelSet()) {
            this.createOrAddToGroup(command, ((PropertyRecord)command.getAfter()).getRelId(), this.propertyCommandsByRelationshipIds);
        }
        return false;
    }

    private void createOrAddToGroup(Command.PropertyCommand command, long entityId, MutableLongObjectMap<List<Command.PropertyCommand>> propertyCommandsByEntityIds) {
        ArrayList<Command.PropertyCommand> group = (ArrayList<Command.PropertyCommand>)propertyCommandsByEntityIds.get(entityId);
        if (group == null) {
            group = new ArrayList<Command.PropertyCommand>();
            propertyCommandsByEntityIds.put(entityId, group);
        }
        group.add(command);
        this.hasUpdates = true;
    }

    public boolean containsAnyEntityOrPropertyUpdate() {
        return this.hasUpdates;
    }

    public LongObjectMap<Command.NodeCommand> nodeCommandsById() {
        return this.nodeCommandsById;
    }

    public LongObjectMap<Command.RelationshipCommand> relationshipCommandsById() {
        return this.relationshipCommandsById;
    }

    public LongObjectMap<List<Command.PropertyCommand>> propertyCommandsByNodeIds() {
        return this.propertyCommandsByNodeIds;
    }

    public LongObjectMap<List<Command.PropertyCommand>> propertyCommandsByRelationshipIds() {
        return this.propertyCommandsByRelationshipIds;
    }
}

