/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class PropertyContainerStateImpl
implements PropertyContainerState {
    private final long id;
    private MutableLongObjectMap<Value> addedProperties;
    private MutableLongObjectMap<Value> changedProperties;
    private MutableLongSet removedProperties;
    protected final CollectionsFactory collectionsFactory;

    PropertyContainerStateImpl(long id2, CollectionsFactory collectionsFactory) {
        this.id = id2;
        this.collectionsFactory = Objects.requireNonNull(collectionsFactory);
    }

    public long getId() {
        return this.id;
    }

    void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    void changeProperty(int propertyKeyId, Value value2) {
        if (this.addedProperties != null && this.addedProperties.containsKey(propertyKeyId)) {
            this.addedProperties.put(propertyKeyId, value2);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = this.collectionsFactory.newValuesMap();
        }
        this.changedProperties.put(propertyKeyId, value2);
        if (this.removedProperties != null) {
            this.removedProperties.remove(propertyKeyId);
        }
    }

    void addProperty(int propertyKeyId, Value value2) {
        if (this.removedProperties != null && this.removedProperties.remove(propertyKeyId)) {
            this.changeProperty(propertyKeyId, value2);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = this.collectionsFactory.newValuesMap();
        }
        this.addedProperties.put(propertyKeyId, value2);
    }

    void removeProperty(int propertyKeyId) {
        if (this.addedProperties != null && this.addedProperties.remove(propertyKeyId) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = this.collectionsFactory.newLongSet();
        }
        this.removedProperties.add(propertyKeyId);
        if (this.changedProperties != null) {
            this.changedProperties.remove(propertyKeyId);
        }
    }

    @Override
    public Iterator<StorageProperty> addedProperties() {
        return this.toPropertyIterator(this.addedProperties);
    }

    @Override
    public Iterator<StorageProperty> changedProperties() {
        return this.toPropertyIterator(this.changedProperties);
    }

    @Override
    public IntIterable removedProperties() {
        return this.removedProperties == null ? IntSets.immutable.empty() : this.removedProperties.asLazy().collectInt(Math::toIntExact);
    }

    @Override
    public Iterator<StorageProperty> addedAndChangedProperties() {
        if (this.addedProperties == null) {
            return this.toPropertyIterator(this.changedProperties);
        }
        if (this.changedProperties == null) {
            return this.toPropertyIterator(this.addedProperties);
        }
        return Iterators.concat(this.toPropertyIterator(this.addedProperties), this.toPropertyIterator(this.changedProperties));
    }

    @Override
    public boolean hasPropertyChanges() {
        return this.addedProperties != null || this.removedProperties != null || this.changedProperties != null;
    }

    @Override
    public boolean isPropertyChangedOrRemoved(int propertyKey) {
        return this.removedProperties != null && this.removedProperties.contains(propertyKey) || this.changedProperties != null && this.changedProperties.containsKey(propertyKey);
    }

    @Override
    public Value propertyValue(int propertyKey) {
        Value addedValue;
        if (this.removedProperties != null && this.removedProperties.contains(propertyKey)) {
            return Values.NO_VALUE;
        }
        if (this.addedProperties != null && (addedValue = (Value)this.addedProperties.get(propertyKey)) != null) {
            return addedValue;
        }
        if (this.changedProperties != null) {
            return (Value)this.changedProperties.get(propertyKey);
        }
        return null;
    }

    private Iterator<StorageProperty> toPropertyIterator(LongObjectMap<Value> propertyMap) {
        return propertyMap == null ? Collections.emptyIterator() : propertyMap.keyValuesView().collect(e -> new PropertyKeyValue(Math.toIntExact(e.getOne()), (Value)e.getTwo())).iterator();
    }
}

