/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.UnmodifiableMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptorPredicates;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.state.GraphStateImpl;
import org.neo4j.kernel.impl.api.state.NodeStateImpl;
import org.neo4j.kernel.impl.api.state.RelationshipStateImpl;
import org.neo4j.kernel.impl.util.collection.CollectionsFactory;
import org.neo4j.kernel.impl.util.collection.OnHeapCollectionsFactory;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableDiffSetsImpl;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSets;
import org.neo4j.kernel.impl.util.diffsets.MutableLongDiffSetsImpl;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.txstate.DiffSets;
import org.neo4j.storageengine.api.txstate.GraphState;
import org.neo4j.storageengine.api.txstate.LongDiffSets;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.api.txstate.RelationshipState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

public class TxState
implements TransactionState,
RelationshipVisitor.Home {
    private final CollectionsFactory collectionsFactory;
    private MutableLongObjectMap<MutableLongDiffSets> labelStatesMap;
    private MutableLongObjectMap<NodeStateImpl> nodeStatesMap;
    private MutableLongObjectMap<RelationshipStateImpl> relationshipStatesMap;
    private MutableLongObjectMap<String> createdLabelTokens;
    private MutableLongObjectMap<String> createdPropertyKeyTokens;
    private MutableLongObjectMap<String> createdRelationshipTypeTokens;
    private GraphStateImpl graphState;
    private MutableDiffSets<IndexDescriptor> indexChanges;
    private MutableDiffSets<ConstraintDescriptor> constraintsChanges;
    private RemovalsCountingDiffSets nodes;
    private RemovalsCountingDiffSets relationships;
    private MutableObjectLongMap<IndexBackedConstraintDescriptor> createdConstraintIndexesByConstraint;
    private Map<SchemaDescriptor, Map<ValueTuple, MutableLongDiffSets>> indexUpdates;
    private long revision;
    private long dataRevision;

    public TxState() {
        this(OnHeapCollectionsFactory.INSTANCE);
    }

    public TxState(CollectionsFactory collectionsFactory) {
        this.collectionsFactory = collectionsFactory;
    }

    @Override
    public void accept(TxStateVisitor visitor) throws ConstraintValidationException, CreateConstraintFailureException {
        if (this.nodes != null) {
            this.nodes.getAdded().each(visitor::visitCreatedNode);
        }
        if (this.relationships != null) {
            LongIterator added = this.relationships.getAdded().longIterator();
            while (added.hasNext()) {
                long relId = added.next();
                if (this.relationshipVisit(relId, visitor::visitCreatedRelationship)) continue;
                throw new IllegalStateException("No RelationshipState for added relationship!");
            }
            this.relationships.getRemoved().forEach(visitor::visitDeletedRelationship);
        }
        if (this.nodes != null) {
            this.nodes.getRemoved().each(visitor::visitDeletedNode);
        }
        for (NodeState node : this.modifiedNodes()) {
            LongDiffSets labelDiffSets;
            if (node.hasPropertyChanges()) {
                visitor.visitNodePropertyChanges(node.getId(), node.addedProperties(), node.changedProperties(), node.removedProperties());
            }
            if ((labelDiffSets = node.labelDiffSets()).isEmpty()) continue;
            visitor.visitNodeLabelChanges(node.getId(), labelDiffSets.getAdded(), labelDiffSets.getRemoved());
        }
        for (RelationshipState rel : this.modifiedRelationships()) {
            visitor.visitRelPropertyChanges(rel.getId(), rel.addedProperties(), rel.changedProperties(), rel.removedProperties());
        }
        if (this.graphState != null) {
            visitor.visitGraphPropertyChanges(this.graphState.addedProperties(), this.graphState.changedProperties(), this.graphState.removedProperties());
        }
        if (this.indexChanges != null) {
            this.indexChanges.getAdded().forEach(visitor::visitAddedIndex);
            this.indexChanges.getRemoved().forEach(visitor::visitRemovedIndex);
        }
        if (this.constraintsChanges != null) {
            for (ConstraintDescriptor added : this.constraintsChanges.getAdded()) {
                visitor.visitAddedConstraint(added);
            }
            this.constraintsChanges.getRemoved().forEach(visitor::visitRemovedConstraint);
        }
        if (this.createdLabelTokens != null) {
            this.createdLabelTokens.forEachKeyValue(visitor::visitCreatedLabelToken);
        }
        if (this.createdPropertyKeyTokens != null) {
            this.createdPropertyKeyTokens.forEachKeyValue(visitor::visitCreatedPropertyKeyToken);
        }
        if (this.createdRelationshipTypeTokens != null) {
            this.createdRelationshipTypeTokens.forEachKeyValue(visitor::visitCreatedRelationshipTypeToken);
        }
    }

    @Override
    public boolean hasChanges() {
        return this.revision != 0L;
    }

    @Override
    public Iterable<NodeState> modifiedNodes() {
        return this.nodeStatesMap == null ? Iterables.empty() : Iterables.cast(this.nodeStatesMap.values());
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateLabelStateNodeDiffSets(long labelId) {
        if (this.labelStatesMap == null) {
            this.labelStatesMap = new LongObjectHashMap<MutableLongDiffSets>();
        }
        return this.labelStatesMap.getIfAbsentPut(labelId, () -> new MutableLongDiffSetsImpl(this.collectionsFactory));
    }

    private LongDiffSets getLabelStateNodeDiffSets(long labelId) {
        if (this.labelStatesMap == null) {
            return LongDiffSets.EMPTY;
        }
        LongDiffSets nodeDiffSets = (LongDiffSets)this.labelStatesMap.get(labelId);
        return nodeDiffSets == null ? LongDiffSets.EMPTY : nodeDiffSets;
    }

    @Override
    public LongDiffSets nodeStateLabelDiffSets(long nodeId) {
        return this.getNodeState(nodeId).labelDiffSets();
    }

    private MutableLongDiffSets getOrCreateNodeStateLabelDiffSets(long nodeId) {
        return this.getOrCreateNodeState(nodeId).getOrCreateLabelDiffSets();
    }

    @Override
    public boolean nodeIsAddedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.isAdded(nodeId);
    }

    @Override
    public boolean relationshipIsAddedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.isAdded(relationshipId);
    }

    private void changed() {
        ++this.revision;
    }

    private void dataChanged() {
        this.changed();
        this.dataRevision = this.revision;
    }

    @Override
    public void nodeDoCreate(long id2) {
        this.nodes().add(id2);
        this.dataChanged();
    }

    @Override
    public void nodeDoDelete(long nodeId) {
        NodeStateImpl nodeState;
        this.nodes().remove(nodeId);
        if (this.nodeStatesMap != null && (nodeState = this.nodeStatesMap.remove(nodeId)) != null) {
            LongDiffSets diff2 = nodeState.labelDiffSets();
            diff2.getAdded().each(label -> this.getOrCreateLabelStateNodeDiffSets(label).remove(nodeId));
            nodeState.clearIndexDiffs(nodeId);
            nodeState.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoCreate(long id2, int relationshipTypeId, long startNodeId, long endNodeId) {
        this.relationships().add(id2);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).addRelationship(id2, relationshipTypeId, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).addRelationship(id2, relationshipTypeId, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).addRelationship(id2, relationshipTypeId, RelationshipDirection.INCOMING);
        }
        this.getOrCreateRelationshipState(id2).setMetaData(startNodeId, endNodeId, relationshipTypeId);
        this.dataChanged();
    }

    @Override
    public boolean nodeIsDeletedInThisTx(long nodeId) {
        return this.nodes != null && this.nodes.wasRemoved(nodeId);
    }

    @Override
    public void relationshipDoDelete(long id2, int type, long startNodeId, long endNodeId) {
        RelationshipStateImpl removed;
        this.relationships().remove(id2);
        if (startNodeId == endNodeId) {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id2, type, RelationshipDirection.LOOP);
        } else {
            this.getOrCreateNodeState(startNodeId).removeRelationship(id2, type, RelationshipDirection.OUTGOING);
            this.getOrCreateNodeState(endNodeId).removeRelationship(id2, type, RelationshipDirection.INCOMING);
        }
        if (this.relationshipStatesMap != null && (removed = this.relationshipStatesMap.remove(id2)) != null) {
            removed.clear();
        }
        this.dataChanged();
    }

    @Override
    public void relationshipDoDeleteAddedInThisTx(long relationshipId) {
        this.getRelationshipState(relationshipId).accept(this::relationshipDoDelete);
    }

    @Override
    public boolean relationshipIsDeletedInThisTx(long relationshipId) {
        return this.relationships != null && this.relationships.wasRemoved(relationshipId);
    }

    @Override
    public void nodeDoAddProperty(long nodeId, int newPropertyKeyId, Value value2) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        nodeState.addProperty(newPropertyKeyId, value2);
        this.dataChanged();
    }

    @Override
    public void nodeDoChangeProperty(long nodeId, int propertyKeyId, Value newValue) {
        this.getOrCreateNodeState(nodeId).changeProperty(propertyKeyId, newValue);
        this.dataChanged();
    }

    @Override
    public void relationshipDoReplaceProperty(long relationshipId, int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateRelationshipState(relationshipId).changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateRelationshipState(relationshipId).addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void graphDoReplaceProperty(int propertyKeyId, Value replacedValue, Value newValue) {
        if (replacedValue != Values.NO_VALUE) {
            this.getOrCreateGraphState().changeProperty(propertyKeyId, newValue);
        } else {
            this.getOrCreateGraphState().addProperty(propertyKeyId, newValue);
        }
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveProperty(long nodeId, int propertyKeyId) {
        this.getOrCreateNodeState(nodeId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void relationshipDoRemoveProperty(long relationshipId, int propertyKeyId) {
        this.getOrCreateRelationshipState(relationshipId).removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void graphDoRemoveProperty(int propertyKeyId) {
        this.getOrCreateGraphState().removeProperty(propertyKeyId);
        this.dataChanged();
    }

    @Override
    public void nodeDoAddLabel(long labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).add(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).add(labelId);
        this.dataChanged();
    }

    @Override
    public void nodeDoRemoveLabel(long labelId, long nodeId) {
        this.getOrCreateLabelStateNodeDiffSets(labelId).remove(nodeId);
        this.getOrCreateNodeStateLabelDiffSets(nodeId).remove(labelId);
        this.dataChanged();
    }

    @Override
    public void labelDoCreateForName(String labelName, long id2) {
        if (this.createdLabelTokens == null) {
            this.createdLabelTokens = new LongObjectHashMap<String>();
        }
        this.createdLabelTokens.put(id2, labelName);
        this.changed();
    }

    @Override
    public void propertyKeyDoCreateForName(String propertyKeyName, int id2) {
        if (this.createdPropertyKeyTokens == null) {
            this.createdPropertyKeyTokens = new LongObjectHashMap<String>();
        }
        this.createdPropertyKeyTokens.put(id2, propertyKeyName);
        this.changed();
    }

    @Override
    public void relationshipTypeDoCreateForName(String labelName, int id2) {
        if (this.createdRelationshipTypeTokens == null) {
            this.createdRelationshipTypeTokens = new LongObjectHashMap<String>();
        }
        this.createdRelationshipTypeTokens.put(id2, labelName);
        this.changed();
    }

    @Override
    public NodeState getNodeState(long id2) {
        if (this.nodeStatesMap == null) {
            return NodeStateImpl.EMPTY;
        }
        NodeState nodeState = (NodeState)this.nodeStatesMap.get(id2);
        return nodeState == null ? NodeStateImpl.EMPTY : nodeState;
    }

    @Override
    public RelationshipState getRelationshipState(long id2) {
        if (this.relationshipStatesMap == null) {
            return RelationshipStateImpl.EMPTY;
        }
        RelationshipStateImpl relationshipState = (RelationshipStateImpl)this.relationshipStatesMap.get(id2);
        return relationshipState == null ? RelationshipStateImpl.EMPTY : relationshipState;
    }

    @Override
    public GraphState getGraphState() {
        return this.graphState;
    }

    @Override
    public MutableLongSet augmentLabels(MutableLongSet labels2, NodeState nodeState) {
        LongDiffSets labelDiffSets = nodeState.labelDiffSets();
        if (!labelDiffSets.isEmpty()) {
            labelDiffSets.getRemoved().forEach(labels2::remove);
            labelDiffSets.getAdded().forEach(labels2::add);
        }
        return labels2;
    }

    @Override
    public LongDiffSets nodesWithLabelChanged(long label) {
        return this.getLabelStateNodeDiffSets(label);
    }

    @Override
    public void indexDoAdd(IndexDescriptor descriptor) {
        MutableDiffSets<IndexDescriptor> diff2 = this.indexChangesDiffSets();
        if (!diff2.unRemove(descriptor)) {
            diff2.add(descriptor);
        }
        this.changed();
    }

    @Override
    public void indexDoDrop(IndexDescriptor descriptor) {
        this.indexChangesDiffSets().remove(descriptor);
        this.changed();
    }

    @Override
    public boolean indexDoUnRemove(IndexDescriptor descriptor) {
        return this.indexChangesDiffSets().unRemove(descriptor);
    }

    @Override
    public DiffSets<IndexDescriptor> indexDiffSetsByLabel(int labelId) {
        return this.indexChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel(labelId));
    }

    @Override
    public DiffSets<IndexDescriptor> indexDiffSetsBySchema(SchemaDescriptor schema) {
        return this.indexChangesDiffSets().filterAdded(indexDescriptor -> indexDescriptor.schema().equals(schema));
    }

    @Override
    public DiffSets<IndexDescriptor> indexChanges() {
        return DiffSets.Empty.ifNull(this.indexChanges);
    }

    private MutableDiffSets<IndexDescriptor> indexChangesDiffSets() {
        if (this.indexChanges == null) {
            this.indexChanges = new MutableDiffSetsImpl<IndexDescriptor>();
        }
        return this.indexChanges;
    }

    @Override
    public LongDiffSets addedAndRemovedNodes() {
        return this.nodes == null ? LongDiffSets.EMPTY : this.nodes;
    }

    private RemovalsCountingDiffSets nodes() {
        if (this.nodes == null) {
            this.nodes = new RemovalsCountingDiffSets();
        }
        return this.nodes;
    }

    @Override
    public LongDiffSets addedAndRemovedRelationships() {
        return this.relationships == null ? LongDiffSets.EMPTY : this.relationships;
    }

    private RemovalsCountingDiffSets relationships() {
        if (this.relationships == null) {
            this.relationships = new RemovalsCountingDiffSets();
        }
        return this.relationships;
    }

    @Override
    public Iterable<RelationshipState> modifiedRelationships() {
        return this.relationshipStatesMap == null ? Iterables.empty() : Iterables.cast(this.relationshipStatesMap.values());
    }

    @VisibleForTesting
    NodeStateImpl getOrCreateNodeState(long nodeId) {
        if (this.nodeStatesMap == null) {
            this.nodeStatesMap = new LongObjectHashMap<NodeStateImpl>();
        }
        return this.nodeStatesMap.getIfAbsentPut(nodeId, () -> new NodeStateImpl(nodeId, this.collectionsFactory));
    }

    private RelationshipStateImpl getOrCreateRelationshipState(long relationshipId) {
        if (this.relationshipStatesMap == null) {
            this.relationshipStatesMap = new LongObjectHashMap<RelationshipStateImpl>();
        }
        return this.relationshipStatesMap.getIfAbsentPut(relationshipId, () -> new RelationshipStateImpl(relationshipId, this.collectionsFactory));
    }

    @VisibleForTesting
    GraphStateImpl getOrCreateGraphState() {
        if (this.graphState == null) {
            this.graphState = new GraphStateImpl(this.collectionsFactory);
        }
        return this.graphState;
    }

    @Override
    public void constraintDoAdd(IndexBackedConstraintDescriptor constraint, long indexId) {
        this.constraintsChangesDiffSets().add(constraint);
        this.createdConstraintIndexesByConstraint().put(constraint, indexId);
        this.changed();
    }

    @Override
    public void constraintDoAdd(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().add(constraint);
        this.changed();
    }

    @Override
    public DiffSets<ConstraintDescriptor> constraintsChangesForLabel(int labelId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasLabel(labelId));
    }

    @Override
    public DiffSets<ConstraintDescriptor> constraintsChangesForSchema(SchemaDescriptor descriptor) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptor.equalTo(descriptor));
    }

    @Override
    public DiffSets<ConstraintDescriptor> constraintsChangesForRelationshipType(int relTypeId) {
        return this.constraintsChangesDiffSets().filterAdded(SchemaDescriptorPredicates.hasRelType(relTypeId));
    }

    @Override
    public DiffSets<ConstraintDescriptor> constraintsChanges() {
        return DiffSets.Empty.ifNull(this.constraintsChanges);
    }

    private MutableDiffSets<ConstraintDescriptor> constraintsChangesDiffSets() {
        if (this.constraintsChanges == null) {
            this.constraintsChanges = new MutableDiffSetsImpl<ConstraintDescriptor>();
        }
        return this.constraintsChanges;
    }

    @Override
    public void constraintDoDrop(ConstraintDescriptor constraint) {
        this.constraintsChangesDiffSets().remove(constraint);
        if (constraint.enforcesUniqueness()) {
            this.indexDoDrop(TxState.getIndexForIndexBackedConstraint((IndexBackedConstraintDescriptor)constraint));
        }
        this.changed();
    }

    @Override
    public boolean constraintDoUnRemove(ConstraintDescriptor constraint) {
        return this.constraintsChangesDiffSets().unRemove(constraint);
    }

    @Override
    public Iterable<IndexDescriptor> constraintIndexesCreatedInTx() {
        if (this.createdConstraintIndexesByConstraint != null && !this.createdConstraintIndexesByConstraint.isEmpty()) {
            return Iterables.map(TxState::getIndexForIndexBackedConstraint, this.createdConstraintIndexesByConstraint.keySet());
        }
        return Iterables.empty();
    }

    @Override
    public Long indexCreatedForConstraint(ConstraintDescriptor constraint) {
        return this.createdConstraintIndexesByConstraint == null ? null : Long.valueOf(this.createdConstraintIndexesByConstraint.get(constraint));
    }

    @Override
    @Nullable
    public UnmodifiableMap<ValueTuple, ? extends LongDiffSets> getIndexUpdates(SchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, MutableLongDiffSets> updates = this.indexUpdates.get(schema);
        if (updates == null) {
            return null;
        }
        return new UnmodifiableMap<ValueTuple, MutableLongDiffSets>(updates);
    }

    @Override
    @Nullable
    public NavigableMap<ValueTuple, ? extends LongDiffSets> getSortedIndexUpdates(SchemaDescriptor descriptor) {
        TreeMap<ValueTuple, MutableLongDiffSets> sortedUpdates;
        if (this.indexUpdates == null) {
            return null;
        }
        Map<ValueTuple, MutableLongDiffSets> updates = this.indexUpdates.get(descriptor);
        if (updates == null) {
            return null;
        }
        if (updates instanceof TreeMap) {
            sortedUpdates = (TreeMap<ValueTuple, MutableLongDiffSets>)updates;
        } else {
            sortedUpdates = new TreeMap<ValueTuple, MutableLongDiffSets>(ValueTuple.COMPARATOR);
            sortedUpdates.putAll(updates);
            this.indexUpdates.put(descriptor, sortedUpdates);
        }
        return Collections.unmodifiableNavigableMap(sortedUpdates);
    }

    @Override
    public void indexDoUpdateEntry(SchemaDescriptor descriptor, long nodeId, ValueTuple propertiesBefore, ValueTuple propertiesAfter) {
        NodeStateImpl nodeState = this.getOrCreateNodeState(nodeId);
        Map<ValueTuple, MutableLongDiffSets> updates = this.getOrCreateIndexUpdatesByDescriptor(descriptor);
        if (propertiesBefore != null) {
            MutableLongDiffSets before = this.getOrCreateIndexUpdatesForSeek(updates, propertiesBefore);
            before.remove(nodeId);
            if (before.getRemoved().contains(nodeId)) {
                nodeState.addIndexDiff(before);
            } else {
                nodeState.removeIndexDiff(before);
            }
        }
        if (propertiesAfter != null) {
            MutableLongDiffSets after = this.getOrCreateIndexUpdatesForSeek(updates, propertiesAfter);
            after.add(nodeId);
            if (after.getAdded().contains(nodeId)) {
                nodeState.addIndexDiff(after);
            } else {
                nodeState.removeIndexDiff(after);
            }
        }
    }

    @VisibleForTesting
    MutableLongDiffSets getOrCreateIndexUpdatesForSeek(Map<ValueTuple, MutableLongDiffSets> updates, ValueTuple values2) {
        return updates.computeIfAbsent(values2, value2 -> new MutableLongDiffSetsImpl(this.collectionsFactory));
    }

    private Map<ValueTuple, MutableLongDiffSets> getOrCreateIndexUpdatesByDescriptor(SchemaDescriptor schema) {
        if (this.indexUpdates == null) {
            this.indexUpdates = new HashMap<SchemaDescriptor, Map<ValueTuple, MutableLongDiffSets>>();
        }
        return this.indexUpdates.computeIfAbsent(schema, k -> new HashMap());
    }

    private MutableObjectLongMap<IndexBackedConstraintDescriptor> createdConstraintIndexesByConstraint() {
        if (this.createdConstraintIndexesByConstraint == null) {
            this.createdConstraintIndexesByConstraint = new ObjectLongHashMap<IndexBackedConstraintDescriptor>();
        }
        return this.createdConstraintIndexesByConstraint;
    }

    private static IndexDescriptor getIndexForIndexBackedConstraint(IndexBackedConstraintDescriptor constraint) {
        return constraint.ownedIndexDescriptor();
    }

    @Override
    public <EX extends Exception> boolean relationshipVisit(long relId, RelationshipVisitor<EX> visitor) throws EX {
        return this.getRelationshipState(relId).accept(visitor);
    }

    @Override
    public boolean hasDataChanges() {
        return this.dataRevision != 0L;
    }

    public long getDataRevision() {
        return this.dataRevision;
    }

    private class RemovalsCountingDiffSets
    extends MutableLongDiffSetsImpl {
        private MutableLongSet removedFromAdded;

        RemovalsCountingDiffSets() {
            super(TxState.this.collectionsFactory);
        }

        @Override
        public boolean remove(long elem2) {
            if (this.isAdded(elem2) && super.remove(elem2)) {
                if (this.removedFromAdded == null) {
                    this.removedFromAdded = TxState.this.collectionsFactory.newLongSet();
                }
                this.removedFromAdded.add(elem2);
                return true;
            }
            return super.remove(elem2);
        }

        private boolean wasRemoved(long id2) {
            return this.removedFromAdded != null && this.removedFromAdded.contains(id2) || super.isRemoved(id2);
        }
    }
}

