/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.function.IntPredicate;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.ReadOnlyDbException;
import org.neo4j.kernel.impl.core.AbstractTokenHolderBase;
import org.neo4j.kernel.impl.core.NonUniqueTokenException;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenRegistry;

public class DelegatingTokenHolder
extends AbstractTokenHolderBase {
    private final TokenCreator tokenCreator;

    public DelegatingTokenHolder(TokenCreator tokenCreator, String tokenType) {
        super(new TokenRegistry(tokenType));
        this.tokenCreator = tokenCreator;
    }

    @Override
    protected synchronized int createToken(String name) throws KernelException {
        Integer id2 = this.tokenRegistry.getId(name);
        if (id2 != null) {
            return id2;
        }
        id2 = this.tokenCreator.createToken(name);
        try {
            this.tokenRegistry.put(new NamedToken(name, id2));
        }
        catch (NonUniqueTokenException e) {
            throw new IllegalStateException("Newly created token should be unique.", e);
        }
        return id2;
    }

    @Override
    public void getOrCreateIds(String[] names, int[] ids) {
        if (names.length != ids.length) {
            throw new IllegalArgumentException("Name and id arrays must have the same length.");
        }
        boolean hasUnresolvedTokens = this.resolveIds(names, ids, Predicates.ALWAYS_TRUE_INT);
        if (hasUnresolvedTokens) {
            this.createMissingTokens(names, ids);
        }
    }

    private synchronized void createMissingTokens(String[] names, int[] ids) {
        IntHashSet unresolvedIndexes = new IntHashSet();
        this.resolveIds(names, ids, i -> !unresolvedIndexes.add(i));
        if (!unresolvedIndexes.isEmpty()) {
            ObjectIntHashMap<String> createdTokens = this.createUnresolvedTokens(unresolvedIndexes, names, ids);
            ArrayList<NamedToken> createdTokensList = new ArrayList<NamedToken>(createdTokens.size());
            createdTokens.forEachKeyValue((name, index) -> createdTokensList.add(new NamedToken((String)name, ids[index])));
            this.tokenRegistry.putAll(createdTokensList);
        }
    }

    private ObjectIntHashMap<String> createUnresolvedTokens(IntSet unresolvedIndexes, String[] names, int[] ids) {
        try {
            ObjectIntHashMap<String> createdTokens = new ObjectIntHashMap<String>();
            IntIntHashMap remappingIndexes = new IntIntHashMap();
            IntPredicate tokenCreateFilter = index -> {
                String name;
                int creatingIndex;
                boolean needsCreate = unresolvedIndexes.contains(index);
                if (needsCreate && (creatingIndex = createdTokens.getIfAbsentPut(name = names[index], index)) != index) {
                    remappingIndexes.put(index, creatingIndex);
                    needsCreate = false;
                }
                return needsCreate;
            };
            this.tokenCreator.createTokens(names, ids, tokenCreateFilter);
            if (remappingIndexes.notEmpty()) {
                remappingIndexes.forEachKeyValue((index, creatingIndex) -> {
                    ids[index] = ids[creatingIndex];
                });
            }
            return createdTokens;
        }
        catch (ReadOnlyDbException e) {
            throw new TransactionFailureException(e.getMessage(), e);
        }
        catch (Throwable e) {
            throw new TransactionFailureException("Could not create tokens.", e);
        }
    }
}

