/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.Kernel;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.impl.core.TokenCreator;

abstract class IsolatedTransactionTokenCreator
implements TokenCreator {
    private final Supplier<Kernel> kernelSupplier;

    IsolatedTransactionTokenCreator(Supplier<Kernel> kernelSupplier) {
        this.kernelSupplier = kernelSupplier;
    }

    @Override
    public synchronized int createToken(String name) throws KernelException {
        Kernel kernel = this.kernelSupplier.get();
        try (Object tx = kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            int id2 = this.createKey((Transaction)tx, name);
            tx.success();
            int n = id2;
            return n;
        }
    }

    @Override
    public synchronized void createTokens(String[] names, int[] ids, IntPredicate filter2) throws KernelException {
        Kernel kernel = this.kernelSupplier.get();
        try (Object tx = kernel.beginTransaction(Transaction.Type.implicit, LoginContext.AUTH_DISABLED);){
            for (int i = 0; i < ids.length; ++i) {
                if (!filter2.test(i)) continue;
                ids[i] = this.createKey((Transaction)tx, names[i]);
            }
            tx.success();
        }
    }

    abstract int createKey(Transaction var1, String var2) throws IllegalTokenNameException, TooManyLabelsException;
}

