/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.NotInTransactionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.explicitindex.AutoIndexingKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.impl.core.EmbeddedProxySPI;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.RelationshipVisitor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class RelationshipProxy
implements Relationship,
RelationshipVisitor<RuntimeException> {
    private final EmbeddedProxySPI spi;
    private long id = -1L;
    private long startNode = -1L;
    private long endNode = -1L;
    private int type;

    public RelationshipProxy(EmbeddedProxySPI spi, long id2, long startNode, int type, long endNode) {
        this.spi = spi;
        this.visit(id2, type, startNode, endNode);
    }

    public RelationshipProxy(EmbeddedProxySPI spi, long id2) {
        this.spi = spi;
        this.id = id2;
    }

    @Override
    public final void visit(long id2, int type, long startNode, long endNode) throws RuntimeException {
        this.id = id2;
        this.type = type;
        this.startNode = startNode;
        this.endNode = endNode;
    }

    private void initializeData() {
        if (this.startNode == -1L) {
            KernelTransaction transaction = this.spi.kernelTransaction();
            try (Statement ignore = transaction.acquireStatement();){
                RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
                transaction.dataRead().singleRelationship(this.id, relationships);
                relationships.next();
                this.type = relationships.type();
                this.startNode = relationships.sourceNodeReference();
                this.endNode = relationships.targetNodeReference();
            }
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    private int typeId() {
        this.initializeData();
        return this.type;
    }

    private long sourceId() {
        this.initializeData();
        return this.startNode;
    }

    private long targetId() {
        this.initializeData();
        return this.endNode;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.spi.getGraphDatabase();
    }

    @Override
    public void delete() {
        KernelTransaction transaction = this.spi.kernelTransaction();
        try {
            boolean deleted = transaction.dataWrite().relationshipDelete(this.id);
            if (!deleted) {
                throw new NotFoundException("Unable to delete relationship[" + this.getId() + "] since it is already deleted.");
            }
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while deleting the relationship: " + e.getMessage(), e);
        }
    }

    @Override
    public Node[] getNodes() {
        this.spi.assertInUnterminatedTransaction();
        return new Node[]{this.spi.newNodeProxy(this.sourceId()), this.spi.newNodeProxy(this.targetId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        this.spi.assertInUnterminatedTransaction();
        return this.spi.newNodeProxy(this.getOtherNodeId(node.getId()));
    }

    @Override
    public Node getStartNode() {
        this.spi.assertInUnterminatedTransaction();
        return this.spi.newNodeProxy(this.sourceId());
    }

    @Override
    public Node getEndNode() {
        this.spi.assertInUnterminatedTransaction();
        return this.spi.newNodeProxy(this.targetId());
    }

    @Override
    public long getStartNodeId() {
        return this.sourceId();
    }

    @Override
    public long getEndNodeId() {
        return this.targetId();
    }

    @Override
    public long getOtherNodeId(long id2) {
        long start = this.sourceId();
        long end = this.targetId();
        if (start == id2) {
            return end;
        }
        if (end == id2) {
            return start;
        }
        throw new NotFoundException("Node[" + id2 + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public RelationshipType getType() {
        this.spi.assertInUnterminatedTransaction();
        return this.spi.getRelationshipTypeById(this.typeId());
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        KernelTransaction transaction = this.spi.kernelTransaction();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
            PropertyCursor properties = transaction.ambientPropertyCursor();
            this.singleRelationship(transaction, relationships);
            TokenRead token = transaction.tokenRead();
            relationships.properties(properties);
            while (properties.next()) {
                keys.add(token.propertyKeyName(properties.propertyKey()));
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return keys;
    }

    @Override
    public Map<String, Object> getProperties(String ... keys) {
        Objects.requireNonNull(keys, "Properties keys should be not null array.");
        if (keys.length == 0) {
            return Collections.emptyMap();
        }
        KernelTransaction transaction = this.spi.kernelTransaction();
        int itemsToReturn = keys.length;
        TokenRead token = transaction.tokenRead();
        int[] propertyIds = new int[itemsToReturn];
        for (int i = 0; i < itemsToReturn; ++i) {
            String key = keys[i];
            if (key == null) {
                throw new NullPointerException(String.format("Key %d was null", i));
            }
            propertyIds[i] = token.propertyKey(key);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(itemsToReturn);
        RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
        PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
        this.singleRelationship(transaction, relationships);
        relationships.properties(propertyCursor);
        int propertiesToFind = itemsToReturn;
        block1: while (propertiesToFind > 0 && propertyCursor.next()) {
            int currentKey = propertyCursor.propertyKey();
            for (int i = 0; i < itemsToReturn; ++i) {
                if (propertyIds[i] != currentKey) continue;
                properties.put(keys[i], propertyCursor.propertyValue().asObjectCopy());
                --propertiesToFind;
                continue block1;
            }
        }
        return properties;
    }

    @Override
    public Map<String, Object> getAllProperties() {
        KernelTransaction transaction = this.spi.kernelTransaction();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        try {
            RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
            PropertyCursor propertyCursor = transaction.ambientPropertyCursor();
            TokenRead token = transaction.tokenRead();
            this.singleRelationship(transaction, relationships);
            relationships.properties(propertyCursor);
            while (propertyCursor.next()) {
                properties.put(token.propertyKeyName(propertyCursor.propertyKey()), propertyCursor.propertyValue().asObjectCopy());
            }
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
        return properties;
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.spi.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            throw new NotFoundException(String.format("No such property, '%s'.", key));
        }
        RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        this.singleRelationship(transaction, relationships);
        relationships.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value2 = properties.propertyValue();
            if (value2 == Values.NO_VALUE) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            return value2.asObjectCopy();
        }
        throw new NotFoundException(String.format("No such property, '%s'.", key));
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        KernelTransaction transaction = this.spi.kernelTransaction();
        RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return defaultValue;
        }
        this.singleRelationship(transaction, relationships);
        relationships.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            Value value2 = properties.propertyValue();
            return value2 == Values.NO_VALUE ? defaultValue : value2.asObjectCopy();
        }
        return defaultValue;
    }

    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        KernelTransaction transaction = this.spi.kernelTransaction();
        int propertyKey = transaction.tokenRead().propertyKey(key);
        if (propertyKey == -1) {
            return false;
        }
        RelationshipScanCursor relationships = transaction.ambientRelationshipCursor();
        PropertyCursor properties = transaction.ambientPropertyCursor();
        this.singleRelationship(transaction, relationships);
        relationships.properties(properties);
        while (properties.next()) {
            if (propertyKey != properties.propertyKey()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setProperty(String key, Object value2) {
        int propertyKeyId;
        KernelTransaction transaction = this.spi.kernelTransaction();
        try {
            propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        try (Statement ignore = transaction.acquireStatement();){
            transaction.dataWrite().relationshipSetProperty(this.id, propertyKeyId, Values.of(value2, false));
        }
        catch (IllegalArgumentException e) {
            this.spi.failTransaction();
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while setting property: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        KernelTransaction transaction = this.spi.kernelTransaction();
        try (Statement ignore = transaction.acquireStatement();){
            int propertyKeyId = transaction.tokenWrite().propertyKeyGetOrCreateForName(key);
            Object object = transaction.dataWrite().relationshipRemoveProperty(this.id, propertyKeyId).asObjectCopy();
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (AutoIndexingKernelException e) {
            throw new IllegalStateException("Auto indexing encountered a failure while removing property: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean isType(RelationshipType type) {
        this.spi.assertInUnterminatedTransaction();
        return this.spi.getRelationshipTypeById(this.typeId()).name().equals(type.name());
    }

    public int compareTo(Object rel) {
        Relationship r = (Relationship)rel;
        return Long.compare(this.getId(), r.getId());
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() >>> 32 ^ this.getId());
    }

    public String toString() {
        try {
            String relType = this.spi.getRelationshipTypeById(this.typeId()).name();
            return String.format("(%d)-[%s,%d]->(%d)", this.sourceId(), relType, this.getId(), this.targetId());
        }
        catch (DatabaseShutdownException | NotInTransactionException runtimeException) {
            String relType = "RELTYPE(" + this.type + ")";
            return String.format("(?)-[%s,%d]->(?)", relType, this.getId());
        }
    }

    private void singleRelationship(KernelTransaction transaction, RelationshipScanCursor relationships) {
        transaction.dataRead().singleRelationship(this.id, relationships);
        if (!relationships.next()) {
            throw new NotFoundException(new EntityNotFoundException(EntityType.RELATIONSHIP, this.id));
        }
    }
}

