/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import java.util.Map;
import java.util.Optional;
import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.internal.kernel.api.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.PropertyContainerLocker;

public class PlaceboTransaction
implements InternalTransaction {
    private static final PropertyContainerLocker locker = new PropertyContainerLocker();
    private final KernelTransaction currentTransaction;
    private boolean success;

    public PlaceboTransaction(KernelTransaction currentTransaction) {
        this.currentTransaction = currentTransaction;
    }

    @Override
    public void terminate() {
        this.currentTransaction.markForTermination(Status.Transaction.Terminated);
    }

    @Override
    public void failure() {
        this.currentTransaction.failure();
    }

    @Override
    public void success() {
        this.success = true;
    }

    @Override
    public void close() {
        if (!this.success) {
            this.currentTransaction.failure();
        }
    }

    @Override
    public Lock acquireWriteLock(PropertyContainer entity) {
        return locker.exclusiveLock(this.currentTransaction, entity);
    }

    @Override
    public Lock acquireReadLock(PropertyContainer entity) {
        return locker.sharedLock(this.currentTransaction, entity);
    }

    @Override
    public Transaction.Type transactionType() {
        return this.currentTransaction.transactionType();
    }

    @Override
    public SecurityContext securityContext() {
        return this.currentTransaction.securityContext();
    }

    @Override
    public KernelTransaction.Revertable overrideWith(SecurityContext context) {
        return this.currentTransaction.overrideWith(context);
    }

    @Override
    public Optional<Status> terminationReason() {
        return this.currentTransaction.getReasonIfTerminated();
    }

    @Override
    public void setMetaData(Map<String, Object> txMeta) {
        this.currentTransaction.setMetaData(txMeta);
    }
}

