/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi;

import org.neo4j.graphdb.Lock;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;

public class PropertyContainerLocker {
    public Lock exclusiveLock(KernelTransaction ktx, PropertyContainer container) {
        Throwable throwable = null;
        try (Statement ignore = ktx.acquireStatement();){
            if (container instanceof Node) {
                long id2 = ((Node)container).getId();
                ktx.locks().acquireExclusiveNodeLock(id2);
                CoreAPILock coreAPILock = new CoreAPILock(() -> ktx.locks().releaseExclusiveNodeLock(id2));
                return coreAPILock;
            }
            if (container instanceof Relationship) {
                long id3 = ((Relationship)container).getId();
                ktx.locks().acquireExclusiveRelationshipLock(id3);
                CoreAPILock coreAPILock = new CoreAPILock(() -> ktx.locks().releaseExclusiveRelationshipLock(id3));
                return coreAPILock;
            }
            try {
                throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Lock sharedLock(KernelTransaction ktx, PropertyContainer container) {
        Throwable throwable = null;
        try (Statement ignore = ktx.acquireStatement();){
            if (container instanceof Node) {
                long id2 = ((Node)container).getId();
                ktx.locks().acquireSharedNodeLock(id2);
                CoreAPILock coreAPILock = new CoreAPILock(() -> ktx.locks().releaseSharedNodeLock(id2));
                return coreAPILock;
            }
            if (container instanceof Relationship) {
                long id3 = ((Relationship)container).getId();
                ktx.locks().acquireSharedRelationshipLock(id3);
                CoreAPILock coreAPILock = new CoreAPILock(() -> ktx.locks().releaseSharedRelationshipLock(id3));
                return coreAPILock;
            }
            try {
                throw new UnsupportedOperationException("Only relationships and nodes can be locked.");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static class CoreAPILock
    implements Lock {
        private boolean released;
        private final Runnable release;

        CoreAPILock(Runnable release) {
            this.release = release;
        }

        @Override
        public void release() {
            if (this.released) {
                throw new IllegalStateException("Already released");
            }
            this.released = true;
            this.release.run();
        }
    }
}

