/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.index.IndexPopulationProgress;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.internal.kernel.api.TokenWrite;
import org.neo4j.internal.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.internal.kernel.api.exceptions.KernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.internal.kernel.api.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.SilentTokenNameLookup;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.RepeatedPropertyInCompositeSchemaException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema.constraints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.NodeKeyConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodeKeyConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.PropertyNameUtils;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.UniquenessConstraintDefinition;
import org.neo4j.storageengine.api.EntityType;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.SchemaRule;

public class SchemaImpl
implements Schema {
    private final Supplier<KernelTransaction> transactionSupplier;
    private final InternalSchemaActions actions;

    public SchemaImpl(Supplier<KernelTransaction> transactionSupplier) {
        this.transactionSupplier = transactionSupplier;
        this.actions = new GDBSchemaActions(transactionSupplier);
    }

    @Override
    public IndexCreator indexFor(Label label) {
        return new IndexCreatorImpl(this.actions, label);
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        KernelTransaction transaction = this.transactionSupplier.get();
        try (Statement ignore = transaction.acquireStatement();){
            TokenRead tokenRead = transaction.tokenRead();
            SchemaRead schemaRead = transaction.schemaRead();
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            int labelId = tokenRead.nodeLabel(label.name());
            if (labelId == -1) {
                List<IndexDefinition> list2 = Collections.emptyList();
                return list2;
            }
            Iterator<IndexReference> indexes = schemaRead.indexesGetForLabel(labelId);
            this.addDefinitions(definitions, tokenRead, IndexReference.sortByType(indexes));
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        KernelTransaction transaction = this.transactionSupplier.get();
        SchemaRead schemaRead = transaction.schemaRead();
        try (Statement ignore = transaction.acquireStatement();){
            ArrayList<IndexDefinition> definitions = new ArrayList<IndexDefinition>();
            Iterator<IndexReference> indexes = schemaRead.indexesGetAll();
            this.addDefinitions(definitions, transaction.tokenRead(), IndexReference.sortByType(indexes));
            ArrayList<IndexDefinition> arrayList = definitions;
            return arrayList;
        }
    }

    private IndexDefinition descriptorToDefinition(TokenRead tokenRead, IndexReference index) {
        try {
            SchemaDescriptor schema = index.schema();
            int[] entityTokenIds = schema.getEntityTokenIds();
            boolean constraintIndex = index.isUnique();
            String[] propertyNames = PropertyNameUtils.getPropertyKeys(tokenRead, index.properties());
            switch (schema.entityType()) {
                case NODE: {
                    Label[] labels2 = new Label[entityTokenIds.length];
                    for (int i = 0; i < labels2.length; ++i) {
                        labels2[i] = Label.label(tokenRead.nodeLabelName(entityTokenIds[i]));
                    }
                    return new IndexDefinitionImpl(this.actions, index, labels2, propertyNames, constraintIndex);
                }
                case RELATIONSHIP: {
                    RelationshipType[] relTypes = new RelationshipType[entityTokenIds.length];
                    for (int i = 0; i < relTypes.length; ++i) {
                        relTypes[i] = RelationshipType.withName(tokenRead.relationshipTypeName(entityTokenIds[i]));
                    }
                    return new IndexDefinitionImpl(this.actions, index, relTypes, propertyNames, constraintIndex);
                }
            }
            throw new IllegalArgumentException("Cannot create IndexDefinition for " + (Object)((Object)schema.entityType()) + " entity-typed schema.");
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    private void addDefinitions(List<IndexDefinition> definitions, TokenRead tokenRead, Iterator<IndexReference> indexes) {
        Iterators.addToCollection(Iterators.map(index -> this.descriptorToDefinition(tokenRead, (IndexReference)index), indexes), definitions);
    }

    @Override
    public void awaitIndexOnline(IndexDefinition index, long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long timeout = System.currentTimeMillis() + unit.toMillis(duration);
        do {
            Schema.IndexState state = this.getIndexState(index);
            switch (state) {
                case ONLINE: {
                    return;
                }
                case FAILED: {
                    String cause = this.getIndexFailure(index);
                    String message = IndexPopulationFailure.appendCauseOfFailure(String.format("Index %s entered a %s state. Please see database logs.", new Object[]{index, state}), cause);
                    throw new IllegalStateException(message);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < timeout);
        throw new IllegalStateException("Expected index to come online within a reasonable time.");
    }

    @Override
    public void awaitIndexesOnline(long duration, TimeUnit unit) {
        this.actions.assertInOpenTransaction();
        long millisLeft = TimeUnit.MILLISECONDS.convert(duration, unit);
        ArrayList<IndexDefinition> onlineIndexes = new ArrayList<IndexDefinition>();
        Iterator<IndexDefinition> iter2 = this.getIndexes().iterator();
        while (iter2.hasNext()) {
            if (millisLeft < 0L) {
                throw new IllegalStateException("Expected all indexes to come online within a reasonable time.Indexes brought online: " + onlineIndexes + ". Indexes not guaranteed to be online: " + Iterators.asCollection(iter2));
            }
            IndexDefinition index = iter2.next();
            long millisBefore = System.currentTimeMillis();
            this.awaitIndexOnline(index, millisLeft, TimeUnit.MILLISECONDS);
            millisLeft -= System.currentTimeMillis() - millisBefore;
            onlineIndexes.add(index);
        }
    }

    @Override
    public IndexDefinition getIndexByName(String indexName) {
        Objects.requireNonNull(indexName);
        Iterator<IndexDefinition> indexes = this.getIndexes().iterator();
        IndexDefinition index = null;
        while (indexes.hasNext()) {
            IndexDefinition candidate = indexes.next();
            if (!candidate.getName().equals(indexName)) continue;
            if (index != null) {
                throw new IllegalStateException("Multiple indexes found by the name '" + indexName + "'. Try iterating Schema#getIndexes() and filter by name instead.");
            }
            index = candidate;
        }
        if (index == null) {
            throw new IllegalArgumentException("No index found with the name '" + indexName + "'.");
        }
        return index;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Schema.IndexState getIndexState(IndexDefinition index) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            SchemaRead schemaRead = transaction.schemaRead();
            IndexReference reference = SchemaImpl.getIndexReference(schemaRead, transaction.tokenRead(), (IndexDefinitionImpl)index);
            InternalIndexState indexState = schemaRead.indexGetState(reference);
            switch (indexState) {
                case POPULATING: {
                    Schema.IndexState indexState2 = Schema.IndexState.POPULATING;
                    return indexState2;
                }
                case ONLINE: {
                    Schema.IndexState indexState3 = Schema.IndexState.ONLINE;
                    return indexState3;
                }
                case FAILED: {
                    Schema.IndexState indexState4 = Schema.IndexState.FAILED;
                    return indexState4;
                }
            }
            throw new IllegalArgumentException(String.format("Illegal index state %s", new Object[]{indexState}));
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw this.newIndexNotFoundException(index, e);
        }
    }

    private NotFoundException newIndexNotFoundException(IndexDefinition index, KernelException e) {
        return new NotFoundException("No index was found corresponding to " + index + ".", e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IndexPopulationProgress getIndexPopulationProgress(IndexDefinition index) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            SchemaRead schemaRead = transaction.schemaRead();
            IndexReference descriptor = SchemaImpl.getIndexReference(schemaRead, transaction.tokenRead(), (IndexDefinitionImpl)index);
            PopulationProgress progress = schemaRead.indexGetPopulationProgress(descriptor);
            IndexPopulationProgress indexPopulationProgress = progress.toIndexPopulationProgress();
            return indexPopulationProgress;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw this.newIndexNotFoundException(index, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getIndexFailure(IndexDefinition index) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            SchemaRead schemaRead = transaction.schemaRead();
            IndexReference descriptor = SchemaImpl.getIndexReference(schemaRead, transaction.tokenRead(), (IndexDefinitionImpl)index);
            String string2 = schemaRead.indexGetFailure(descriptor);
            return string2;
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            throw this.newIndexNotFoundException(index, e);
        }
    }

    @Override
    public ConstraintCreator constraintFor(Label label) {
        this.actions.assertInOpenTransaction();
        return new BaseNodeConstraintCreator(this.actions, label);
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(transaction.schemaRead().constraintsGetAll(), transaction.tokenRead());
            return iterable;
        }
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            TokenRead tokenRead = transaction.tokenRead();
            SchemaRead schemaRead = transaction.schemaRead();
            int labelId = tokenRead.nodeLabel(label.name());
            if (labelId == -1) {
                List<ConstraintDefinition> list2 = Collections.emptyList();
                return list2;
            }
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(schemaRead.constraintsGetForLabel(labelId), tokenRead);
            return iterable;
        }
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
        try (Statement ignore = transaction.acquireStatement();){
            TokenRead tokenRead = transaction.tokenRead();
            SchemaRead schemaRead = transaction.schemaRead();
            int typeId = tokenRead.relationshipType(type.name());
            if (typeId == -1) {
                List<ConstraintDefinition> list2 = Collections.emptyList();
                return list2;
            }
            Iterable<ConstraintDefinition> iterable = this.asConstraintDefinitions(schemaRead.constraintsGetForRelationshipType(typeId), tokenRead);
            return iterable;
        }
    }

    private static IndexReference getIndexReference(SchemaRead schemaRead, TokenRead tokenRead, IndexDefinitionImpl index) throws SchemaRuleNotFoundException {
        SchemaDescriptor schema;
        IndexReference reference = index.getIndexReference();
        if (reference != null) {
            return reference;
        }
        int[] propertyKeyIds = SchemaImpl.resolveAndValidatePropertyKeys(tokenRead, index.getPropertyKeysArrayShared());
        if (index.isNodeIndex()) {
            int[] labelIds = SchemaImpl.resolveAndValidateTokens("Label", index.getLabelArrayShared(), Label::name, tokenRead::nodeLabel);
            schema = index.isMultiTokenIndex() ? SchemaDescriptorFactory.multiToken(labelIds, EntityType.NODE, propertyKeyIds) : SchemaDescriptorFactory.forLabel(labelIds[0], propertyKeyIds);
        } else if (index.isRelationshipIndex()) {
            int[] relTypes = SchemaImpl.resolveAndValidateTokens("Relationship type", index.getRelationshipTypesArrayShared(), RelationshipType::name, tokenRead::relationshipType);
            schema = index.isMultiTokenIndex() ? SchemaDescriptorFactory.multiToken(relTypes, EntityType.RELATIONSHIP, propertyKeyIds) : SchemaDescriptorFactory.forRelType(relTypes[0], propertyKeyIds);
        } else {
            throw new IllegalArgumentException("The given index is neither a node index, nor a relationship index: " + index + ".");
        }
        reference = schemaRead.index(schema);
        if (reference == IndexReference.NO_INDEX) {
            throw new SchemaRuleNotFoundException(SchemaRule.Kind.INDEX_RULE, schema);
        }
        return reference;
    }

    private static int[] resolveAndValidatePropertyKeys(TokenRead tokenRead, String[] propertyKeys) {
        return SchemaImpl.resolveAndValidateTokens("Property key", propertyKeys, s2 -> s2, tokenRead::propertyKey);
    }

    private static <T> int[] resolveAndValidateTokens(String tokenTypeName, T[] tokens, Function<T, String> getTokenName, ToIntFunction<String> getTokenId) {
        int[] tokenIds = new int[tokens.length];
        for (int i = 0; i < tokenIds.length; ++i) {
            String tokenName = getTokenName.apply(tokens[i]);
            int tokenId = getTokenId.applyAsInt(tokenName);
            if (tokenId == -1) {
                throw new NotFoundException(tokenTypeName + " " + tokenName + " not found.");
            }
            tokenIds[i] = tokenId;
        }
        return tokenIds;
    }

    private Iterable<ConstraintDefinition> asConstraintDefinitions(Iterator<? extends ConstraintDescriptor> constraints, TokenRead tokenRead) {
        ArrayList<ConstraintDefinition> definitions = new ArrayList<ConstraintDefinition>();
        while (constraints.hasNext()) {
            ConstraintDescriptor constraint = constraints.next();
            definitions.add(this.asConstraintDefinition(constraint, tokenRead));
        }
        return definitions;
    }

    private ConstraintDefinition asConstraintDefinition(ConstraintDescriptor constraint, TokenRead tokenRead) {
        SilentTokenNameLookup lookup2 = new SilentTokenNameLookup(tokenRead);
        if (constraint instanceof NodeExistenceConstraintDescriptor || constraint instanceof NodeKeyConstraintDescriptor || constraint instanceof UniquenessConstraintDescriptor) {
            SchemaDescriptor schemaDescriptor = constraint.schema();
            int[] entityTokenIds = schemaDescriptor.getEntityTokenIds();
            Label[] labels2 = new Label[entityTokenIds.length];
            for (int i = 0; i < entityTokenIds.length; ++i) {
                labels2[i] = Label.label(lookup2.labelGetName(entityTokenIds[i]));
            }
            String[] propertyKeys = (String[])Arrays.stream(schemaDescriptor.getPropertyIds()).mapToObj(lookup2::propertyKeyGetName).toArray(String[]::new);
            if (constraint instanceof NodeExistenceConstraintDescriptor) {
                return new NodePropertyExistenceConstraintDefinition(this.actions, labels2[0], propertyKeys);
            }
            if (constraint instanceof UniquenessConstraintDescriptor) {
                return new UniquenessConstraintDefinition(this.actions, new IndexDefinitionImpl(this.actions, null, labels2, propertyKeys, true));
            }
            return new NodeKeyConstraintDefinition(this.actions, new IndexDefinitionImpl(this.actions, null, labels2, propertyKeys, true));
        }
        if (constraint instanceof RelExistenceConstraintDescriptor) {
            RelationTypeSchemaDescriptor descriptor = (RelationTypeSchemaDescriptor)constraint.schema();
            return new RelationshipPropertyExistenceConstraintDefinition(this.actions, RelationshipType.withName(lookup2.relationshipTypeGetName(descriptor.getRelTypeId())), lookup2.propertyKeyGetName(descriptor.getPropertyId()));
        }
        throw new IllegalArgumentException("Unknown constraint " + constraint);
    }

    private static KernelTransaction safeAcquireTransaction(Supplier<KernelTransaction> transactionSupplier) {
        KernelTransaction transaction = transactionSupplier.get();
        if (transaction.isTerminated()) {
            Status terminationReason = transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
            throw new TransactionTerminatedException(terminationReason);
        }
        return transaction;
    }

    private static class GDBSchemaActions
    implements InternalSchemaActions {
        private final Supplier<KernelTransaction> transactionSupplier;

        GDBSchemaActions(Supplier<KernelTransaction> transactionSupplier) {
            this.transactionSupplier = transactionSupplier;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public IndexDefinition createIndexDefinition(Label label, Optional<String> indexName, String ... propertyKeys) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(label.name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKeys);
                LabelSchemaDescriptor descriptor = SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds);
                IndexReference indexReference = transaction.schemaWrite().indexCreate(descriptor, indexName);
                IndexDefinitionImpl indexDefinitionImpl = new IndexDefinitionImpl((InternalSchemaActions)this, indexReference, new Label[]{label}, propertyKeys, false);
                return indexDefinitionImpl;
            }
            catch (IllegalTokenNameException e) {
                try {
                    throw new IllegalArgumentException(e);
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e2) {
                        throw new ConstraintViolationException(e2.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropIndexDefinitions(IndexDefinition indexDefinition) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    IndexReference reference = SchemaImpl.getIndexReference(transaction.schemaRead(), transaction.tokenRead(), (IndexDefinitionImpl)indexDefinition);
                    transaction.schemaWrite().indexDrop(reference);
                }
                catch (NotFoundException reference) {
                }
                catch (DropIndexFailureException | SchemaRuleNotFoundException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyUniquenessConstraint(IndexDefinition indexDefinition) {
            if (indexDefinition.isMultiTokenIndex()) {
                throw new ConstraintViolationException("A property uniqueness constraint does not support multi-token index definitions. That is, only a single label is supported, but the following labels were provided: " + IndexDefinitionImpl.labelNameList(indexDefinition.getLabels(), "", "."));
            }
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(Iterables.single(indexDefinition.getLabels()).name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                transaction.schemaWrite().uniquePropertyConstraintCreate(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                UniquenessConstraintDefinition uniquenessConstraintDefinition = new UniquenessConstraintDefinition((InternalSchemaActions)this, indexDefinition);
                return uniquenessConstraintDefinition;
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | AlreadyIndexedException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createNodeKeyConstraint(IndexDefinition indexDefinition) {
            if (indexDefinition.isMultiTokenIndex()) {
                throw new ConstraintViolationException("A node key constraint does not support multi-token index definitions. That is, only a single label is supported, but the following labels were provided: " + IndexDefinitionImpl.labelNameList(indexDefinition.getLabels(), "", "."));
            }
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(Iterables.single(indexDefinition.getLabels()).name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, indexDefinition);
                transaction.schemaWrite().nodeKeyConstraintCreate(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                NodeKeyConstraintDefinition nodeKeyConstraintDefinition = new NodeKeyConstraintDefinition((InternalSchemaActions)this, indexDefinition);
                return nodeKeyConstraintDefinition;
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | AlreadyIndexedException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(Label label, String ... propertyKeys) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int labelId = tokenWrite.labelGetOrCreateForName(label.name());
                int[] propertyKeyIds = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKeys);
                transaction.schemaWrite().nodePropertyExistenceConstraintCreate(SchemaDescriptorFactory.forLabel(labelId, propertyKeyIds));
                NodePropertyExistenceConstraintDefinition nodePropertyExistenceConstraintDefinition = new NodePropertyExistenceConstraintDefinition(this, label, propertyKeys);
                return nodePropertyExistenceConstraintDefinition;
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (TooManyLabelsException e3) {
                        throw new IllegalStateException(e3);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e4) {
                        throw new ConstraintViolationException(e4.getMessage(), e4);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ConstraintDefinition createPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            Throwable throwable = null;
            try (Statement ignore = transaction.acquireStatement();){
                TokenWrite tokenWrite = transaction.tokenWrite();
                int typeId = tokenWrite.relationshipTypeGetOrCreateForName(type.name());
                int[] propertyKeyId = PropertyNameUtils.getOrCreatePropertyKeyIds(tokenWrite, propertyKey);
                transaction.schemaWrite().relationshipPropertyExistenceConstraintCreate(SchemaDescriptorFactory.forRelType(typeId, propertyKeyId));
                RelationshipPropertyExistenceConstraintDefinition relationshipPropertyExistenceConstraintDefinition = new RelationshipPropertyExistenceConstraintDefinition(this, type, propertyKey);
                return relationshipPropertyExistenceConstraintDefinition;
            }
            catch (CreateConstraintFailureException | AlreadyConstrainedException | RepeatedPropertyInCompositeSchemaException e) {
                try {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                    catch (IllegalTokenNameException e2) {
                        throw new IllegalArgumentException(e2);
                    }
                    catch (InvalidTransactionTypeKernelException | SchemaKernelException e3) {
                        throw new ConstraintViolationException(e3.getMessage(), e3);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        @Override
        public void dropPropertyUniquenessConstraint(Label label, String[] properties) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int labelId = tokenRead.nodeLabel(label.name());
                    int[] propertyKeyIds = SchemaImpl.resolveAndValidatePropertyKeys(tokenRead, properties);
                    transaction.schemaWrite().constraintDrop(ConstraintDescriptorFactory.uniqueForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public void dropNodeKeyConstraint(Label label, String[] properties) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int labelId = tokenRead.nodeLabel(label.name());
                    int[] propertyKeyIds = SchemaImpl.resolveAndValidatePropertyKeys(tokenRead, properties);
                    transaction.schemaWrite().constraintDrop(ConstraintDescriptorFactory.nodeKeyForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public void dropNodePropertyExistenceConstraint(Label label, String[] properties) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int labelId = tokenRead.nodeLabel(label.name());
                    int[] propertyKeyIds = SchemaImpl.resolveAndValidatePropertyKeys(tokenRead, properties);
                    transaction.schemaWrite().constraintDrop(ConstraintDescriptorFactory.existsForLabel(labelId, propertyKeyIds));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public void dropRelationshipPropertyExistenceConstraint(RelationshipType type, String propertyKey) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                try {
                    TokenRead tokenRead = transaction.tokenRead();
                    int typeId = tokenRead.relationshipType(type.name());
                    int propertyKeyId = tokenRead.propertyKey(propertyKey);
                    transaction.schemaWrite().constraintDrop(ConstraintDescriptorFactory.existsForRelType(typeId, propertyKeyId));
                }
                catch (DropConstraintFailureException e) {
                    throw new ConstraintViolationException(e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead())), e);
                }
                catch (InvalidTransactionTypeKernelException | SchemaKernelException e) {
                    throw new ConstraintViolationException(e.getMessage(), e);
                }
            }
        }

        @Override
        public String getUserMessage(KernelException e) {
            KernelTransaction transaction = SchemaImpl.safeAcquireTransaction(this.transactionSupplier);
            try (Statement ignore = transaction.acquireStatement();){
                String string2 = e.getUserMessage(new SilentTokenNameLookup(transaction.tokenRead()));
                return string2;
            }
        }

        @Override
        public void assertInOpenTransaction() {
            KernelTransaction transaction = this.transactionSupplier.get();
            if (transaction.isTerminated()) {
                Status terminationReason = transaction.getReasonIfTerminated().orElse(Status.Transaction.Terminated);
                throw new TransactionTerminatedException(terminationReason);
            }
        }
    }
}

