/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.util.Random;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NotCurrentStoreVersionException;
import org.neo4j.kernel.impl.storemigration.UpgradeNotAllowedByConfigurationException;

public class IndexProviderStore {
    private static final int RECORD_SIZE = 8;
    private static final int RECORD_COUNT = 5;
    private final long creationTime;
    private final long randomIdentifier;
    private volatile long version;
    private final long indexVersion;
    private final StoreChannel fileChannel;
    private final ByteBuffer buf = ByteBuffer.allocate(40);
    private volatile long lastCommittedTx;
    private final File file;
    private final Random random;

    public IndexProviderStore(File file, FileSystemAbstraction fileSystem, long expectedVersion, boolean allowUpgrade) {
        this.file = file;
        this.random = new Random(System.currentTimeMillis());
        Channel channel = null;
        boolean success = false;
        try {
            if (!fileSystem.fileExists(file) || fileSystem.getFileSize(file) == 0L) {
                this.create(file, fileSystem, expectedVersion);
            }
            channel = fileSystem.open(file, OpenMode.READ_WRITE);
            Long[] records = this.readRecordsWithNullDefaults((StoreChannel)channel, 5, allowUpgrade);
            this.creationTime = records[0];
            this.randomIdentifier = records[1];
            this.version = records[2];
            this.lastCommittedTx = records[3];
            Long readIndexVersion = records[4];
            this.fileChannel = channel;
            boolean versionDiffers = this.compareExpectedVersionWithStoreVersion(expectedVersion, allowUpgrade, readIndexVersion);
            this.indexVersion = expectedVersion;
            if (versionDiffers) {
                this.writeOut();
            }
            success = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!success && channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean compareExpectedVersionWithStoreVersion(long expectedVersion, boolean allowUpgrade, Long readIndexVersion) {
        boolean versionDiffers;
        boolean bl = versionDiffers = readIndexVersion == null || readIndexVersion != expectedVersion;
        if (versionDiffers) {
            if (readIndexVersion != null && expectedVersion < readIndexVersion) {
                String expected = MetaDataStore.versionLongToString(expectedVersion);
                String readVersion = MetaDataStore.versionLongToString(readIndexVersion);
                throw new NotCurrentStoreVersionException(expected, readVersion, "Your index has been upgraded to " + readVersion + " and cannot run with an older version " + expected, false);
            }
            if (!allowUpgrade) {
                throw new UpgradeNotAllowedByConfigurationException();
            }
        }
        return versionDiffers;
    }

    private Long[] readRecordsWithNullDefaults(StoreChannel fileChannel, int count2, boolean allowUpgrade) throws IOException {
        this.buf.clear();
        int bytesRead = fileChannel.read(this.buf);
        int wholeRecordsRead = bytesRead / 8;
        if (wholeRecordsRead < 5 && !allowUpgrade) {
            throw new UpgradeNotAllowedByConfigurationException("Index version (managed by " + this.file + ") has changed and needs to be upgraded");
        }
        this.buf.flip();
        Long[] result2 = new Long[count2];
        for (int i = 0; i < wholeRecordsRead; ++i) {
            result2[i] = this.buf.getLong();
        }
        return result2;
    }

    private void create(File file, FileSystemAbstraction fileSystem, long indexVersion) throws IOException {
        if (fileSystem.fileExists(file) && fileSystem.getFileSize(file) > 0L) {
            throw new IllegalArgumentException(file + " already exist");
        }
        try (StoreChannel fileChannel = fileSystem.open(file, OpenMode.READ_WRITE);){
            this.write(fileChannel, System.currentTimeMillis(), this.random.nextLong(), 0L, 1L, indexVersion);
        }
    }

    private void write(StoreChannel channel, long time, long identifier2, long version, long lastCommittedTxId, long indexVersion) throws IOException {
        this.buf.clear();
        this.buf.putLong(time).putLong(identifier2).putLong(version).putLong(lastCommittedTxId).putLong(indexVersion);
        this.buf.flip();
        channel.writeAll(this.buf, 0L);
        channel.force(true);
    }

    public File getFile() {
        return this.file;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getVersion() {
        return this.version;
    }

    public long getIndexVersion() {
        return this.indexVersion;
    }

    public synchronized void setVersion(long version) {
        this.version = version;
        this.writeOut();
    }

    public synchronized void setLastCommittedTx(long txId) {
        this.lastCommittedTx = txId;
    }

    public long getLastCommittedTx() {
        return this.lastCommittedTx;
    }

    private void writeOut() {
        try {
            this.write(this.fileChannel, this.creationTime, this.randomIdentifier, this.version, this.lastCommittedTx, this.indexVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        if (!this.fileChannel.isOpen()) {
            return;
        }
        this.writeOut();
        try {
            this.fileChannel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

