/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;

class LabelScanLayout
extends Layout.Adapter<LabelScanKey, LabelScanValue> {
    private static final String IDENTIFIER_NAME = "LSL";
    private static final int KEY_SIZE = 10;

    LabelScanLayout() {
    }

    @Override
    public int compare(LabelScanKey o1, LabelScanKey o2) {
        int labelComparison = Integer.compare(o1.labelId, o2.labelId);
        return labelComparison != 0 ? labelComparison : Long.compare(o1.idRange, o2.idRange);
    }

    @Override
    public LabelScanKey newKey() {
        return new LabelScanKey();
    }

    @Override
    public LabelScanKey copyKey(LabelScanKey key, LabelScanKey into) {
        into.labelId = key.labelId;
        into.idRange = key.idRange;
        return into;
    }

    @Override
    public LabelScanValue newValue() {
        return new LabelScanValue();
    }

    @Override
    public int keySize(LabelScanKey key) {
        return 10;
    }

    @Override
    public int valueSize(LabelScanValue value2) {
        return 8;
    }

    @Override
    public void writeKey(PageCursor cursor, LabelScanKey key) {
        cursor.putInt(key.labelId);
        LabelScanLayout.put6ByteLong(cursor, key.idRange);
    }

    private static void put6ByteLong(PageCursor cursor, long value2) {
        cursor.putInt((int)value2);
        cursor.putShort((short)(value2 >>> 32));
    }

    @Override
    public void writeValue(PageCursor cursor, LabelScanValue value2) {
        cursor.putLong(value2.bits);
    }

    @Override
    public void readKey(PageCursor cursor, LabelScanKey into, int keySize) {
        into.labelId = cursor.getInt();
        into.idRange = LabelScanLayout.get6ByteLong(cursor);
    }

    private static long get6ByteLong(PageCursor cursor) {
        long low4b = (long)cursor.getInt() & 0xFFFFFFFFL;
        long high2b = cursor.getShort();
        return low4b | high2b << 32;
    }

    @Override
    public void readValue(PageCursor cursor, LabelScanValue into, int valueSize) {
        into.bits = cursor.getLong();
    }

    @Override
    public boolean fixedSize() {
        return true;
    }

    @Override
    public long identifier() {
        return Layout.namedIdentifier(IDENTIFIER_NAME, 64);
    }

    @Override
    public int majorVersion() {
        return 0;
    }

    @Override
    public int minorVersion() {
        return 1;
    }
}

