/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.helpers.Args;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.storageengine.api.ReadPastEndException;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.util.FeatureToggles;

public class LabelScanWriteMonitor
implements NativeLabelScanWriter.WriteMonitor {
    static final boolean ENABLED = FeatureToggles.flag(LabelScanWriteMonitor.class, "enabled", false);
    private static final long ROTATION_SIZE_THRESHOLD = FeatureToggles.getLong(LabelScanWriteMonitor.class, "rotationThreshold", ByteUnit.mebiBytes(200L));
    private static final long PRUNE_THRESHOLD = FeatureToggles.getLong(LabelScanWriteMonitor.class, "pruneThreshold", TimeUnit.DAYS.toMillis(2L));
    private static final byte TYPE_PREPARE_ADD = 0;
    private static final byte TYPE_PREPARE_REMOVE = 1;
    private static final byte TYPE_MERGE_ADD = 2;
    private static final byte TYPE_MERGE_REMOVE = 3;
    private static final byte TYPE_RANGE = 4;
    private static final byte TYPE_FLUSH = 5;
    private static final byte TYPE_SESSION_END = 6;
    private static final String ARG_TOFILE = "tofile";
    private static final String ARG_TXFILTER = "txfilter";
    private final FileSystemAbstraction fs;
    private final File storeDir;
    private final File file;
    private FlushableChannel channel;
    private Lock lock = new ReentrantLock();
    private LongAdder position = new LongAdder();
    private long rotationThreshold;
    private long pruneThreshold;

    LabelScanWriteMonitor(FileSystemAbstraction fs, DatabaseLayout databaseLayout) {
        this(fs, databaseLayout, ROTATION_SIZE_THRESHOLD, ByteUnit.Byte, PRUNE_THRESHOLD, TimeUnit.MILLISECONDS);
    }

    LabelScanWriteMonitor(FileSystemAbstraction fs, DatabaseLayout databaseLayout, long rotationThreshold, ByteUnit rotationThresholdUnit, long pruneThreshold, TimeUnit pruneThresholdUnit) {
        this.fs = fs;
        this.rotationThreshold = rotationThresholdUnit.toBytes(rotationThreshold);
        this.pruneThreshold = pruneThresholdUnit.toMillis(pruneThreshold);
        this.storeDir = databaseLayout.databaseDirectory();
        this.file = LabelScanWriteMonitor.writeLogBaseFile(databaseLayout);
        try {
            if (fs.fileExists(this.file)) {
                this.moveAwayFile();
            }
            this.channel = this.instantiateChannel();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static File writeLogBaseFile(DatabaseLayout databaseLayout) {
        return new File(databaseLayout.labelScanStore() + ".writelog");
    }

    private PhysicalFlushableChannel instantiateChannel() throws IOException {
        return new PhysicalFlushableChannel(this.fs.open(this.file, OpenMode.READ_WRITE));
    }

    @Override
    public void range(long range2, int labelId) {
        try {
            this.channel.put((byte)4);
            this.channel.putLong(range2);
            this.channel.putInt(labelId);
            this.position.add(13L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void prepareAdd(long txId, int offset) {
        this.prepare((byte)0, txId, offset);
    }

    @Override
    public void prepareRemove(long txId, int offset) {
        this.prepare((byte)1, txId, offset);
    }

    private void prepare(byte type, long txId, int offset) {
        try {
            this.channel.put(type);
            this.channel.putLong(txId);
            this.channel.put((byte)offset);
            this.position.add(10L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void mergeAdd(LabelScanValue existingValue, LabelScanValue newValue) {
        this.merge((byte)2, existingValue, newValue);
    }

    @Override
    public void mergeRemove(LabelScanValue existingValue, LabelScanValue newValue) {
        this.merge((byte)3, existingValue, newValue);
    }

    private void merge(byte type, LabelScanValue existingValue, LabelScanValue newValue) {
        try {
            this.channel.put(type);
            this.channel.putLong(existingValue.bits);
            this.channel.putLong(newValue.bits);
            this.position.add(17L);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flushPendingUpdates() {
        try {
            this.channel.put((byte)5);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void writeSessionEnded() {
        try {
            this.channel.put((byte)6);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.position.add(1L);
        if (this.position.sum() > this.rotationThreshold) {
            this.lock.lock();
            try {
                this.channel.prepareForFlush().flush();
                this.channel.close();
                this.moveAwayFile();
                this.position.reset();
                this.channel = this.instantiateChannel();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            finally {
                this.lock.unlock();
            }
            long time = System.currentTimeMillis();
            long threshold = time - this.pruneThreshold;
            for (File file : this.fs.listFiles(this.storeDir, (dir, name) -> name.startsWith(this.file.getName() + "-"))) {
                if (LabelScanWriteMonitor.millisOf(file) >= threshold) continue;
                this.fs.deleteFile(file);
            }
        }
    }

    static long millisOf(File file) {
        String name = file.getName();
        int dashIndex = name.lastIndexOf(45);
        if (dashIndex == -1) {
            return 0L;
        }
        return Long.parseLong(name.substring(dashIndex + 1));
    }

    @Override
    public void force() {
        this.lock.lock();
        try {
            this.channel.prepareForFlush().flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void moveAwayFile() throws IOException {
        File to2;
        while (this.fs.fileExists(to2 = this.timestampedFile())) {
        }
        this.fs.renameFile(this.file, to2, new CopyOption[0]);
    }

    private File timestampedFile() {
        return new File(this.storeDir, this.file.getName() + "-" + System.currentTimeMillis());
    }

    public static void main(String[] args) throws IOException {
        Args arguments2 = Args.withFlags(ARG_TOFILE).parse(args);
        if (arguments2.orphans().size() == 0) {
            System.err.println("Please supply database directory");
            return;
        }
        DatabaseLayout databaseLayout = DatabaseLayout.of(new File(arguments2.orphans().get(0)));
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        TxFilter txFilter = LabelScanWriteMonitor.parseTxFilter(arguments2.get(ARG_TXFILTER, null));
        PrintStream out = System.out;
        boolean redirectsToFile = arguments2.getBoolean(ARG_TOFILE);
        if (redirectsToFile) {
            File outFile = new File(LabelScanWriteMonitor.writeLogBaseFile(databaseLayout).getAbsolutePath() + ".txt");
            System.out.println("Redirecting output to " + outFile);
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
        }
        PrintStreamDumper dumper = new PrintStreamDumper(out);
        LabelScanWriteMonitor.dump(fs, databaseLayout, dumper, txFilter);
        if (redirectsToFile) {
            out.close();
        }
    }

    public static void dump(FileSystemAbstraction fs, DatabaseLayout databaseLayout, Dumper dumper, TxFilter txFilter) throws IOException {
        File writeLogFile = LabelScanWriteMonitor.writeLogBaseFile(databaseLayout);
        String writeLogFileBaseName = writeLogFile.getName();
        File[] files2 = fs.listFiles(databaseLayout.databaseDirectory(), (dir, name) -> name.startsWith(writeLogFileBaseName));
        Arrays.sort(files2, Comparator.comparing(file -> file.getName().equals(writeLogFileBaseName) ? 0L : LabelScanWriteMonitor.millisOf(file)));
        long session = 0L;
        for (File file2 : files2) {
            dumper.file(file2);
            session = LabelScanWriteMonitor.dumpFile(fs, file2, dumper, txFilter, session);
        }
    }

    private static long dumpFile(FileSystemAbstraction fs, File file, Dumper dumper, TxFilter txFilter, long session) throws IOException {
        try {
            ReadAheadChannel<StoreChannel> channel = new ReadAheadChannel<StoreChannel>(fs.open(file, OpenMode.READ));
            Throwable throwable = null;
            try {
                try {
                    long range2 = -1L;
                    int labelId = -1;
                    long flush2 = 0L;
                    block15: while (true) {
                        byte type = channel.get();
                        switch (type) {
                            case 4: {
                                range2 = channel.getLong();
                                labelId = channel.getInt();
                                if (txFilter == null) continue block15;
                                txFilter.clear();
                                continue block15;
                            }
                            case 0: 
                            case 1: {
                                LabelScanWriteMonitor.dumpPrepare(dumper, type, channel, range2, labelId, txFilter, session, flush2);
                                continue block15;
                            }
                            case 2: 
                            case 3: {
                                LabelScanWriteMonitor.dumpMerge(dumper, type, channel, range2, labelId, txFilter, session, flush2);
                                continue block15;
                            }
                            case 5: {
                                ++flush2;
                                continue block15;
                            }
                            case 6: {
                                ++session;
                                flush2 = 0L;
                                continue block15;
                            }
                        }
                        System.out.println("Unknown type " + type + " at " + channel.position());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (channel != null) {
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        channel.close();
                    }
                }
                throw throwable3;
            }
        }
        catch (ReadPastEndException readPastEndException) {
            return session;
        }
    }

    private static void dumpMerge(Dumper dumper, byte type, ReadableChannel channel, long range2, int labelId, TxFilter txFilter, long session, long flush2) throws IOException {
        long existingBits = channel.getLong();
        long newBits = channel.getLong();
        if (txFilter == null || txFilter.contains()) {
            dumper.merge(type == 2, session, flush2, range2, labelId, existingBits, newBits);
        }
    }

    private static void dumpPrepare(Dumper dumper, byte type, ReadableChannel channel, long range2, int labelId, TxFilter txFilter, long session, long flush2) throws IOException {
        long txId = channel.getLong();
        byte offset = channel.get();
        long nodeId = range2 * 64L + (long)offset;
        if (txFilter == null || txFilter.contains(txId)) {
            dumper.prepare(type == 0, session, flush2, txId, nodeId, labelId);
        }
    }

    static TxFilter parseTxFilter(String txFilter) {
        if (txFilter == null) {
            return null;
        }
        String[] tokens = txFilter.split(",");
        long[][] filters = new long[tokens.length][];
        for (int i = 0; i < tokens.length; ++i) {
            long low;
            long high;
            String token = tokens[i];
            int index = token.lastIndexOf(45);
            if (index == -1) {
                low = high = Long.parseLong(token);
            } else {
                low = Long.parseLong(token.substring(0, index));
                high = Long.parseLong(token.substring(index + 1));
            }
            filters[i] = new long[]{low, high};
        }
        return new TxFilter(filters);
    }

    public static class PrintStreamDumper
    implements Dumper {
        private final PrintStream out;
        private final char[] bitsAsChars = new char[71];

        PrintStreamDumper(PrintStream out) {
            this.out = out;
            Arrays.fill(this.bitsAsChars, ' ');
        }

        @Override
        public void file(File file) {
            this.out.println("=== " + file.getAbsolutePath() + " ===");
        }

        @Override
        public void prepare(boolean add2, long session, long flush2, long txId, long nodeId, int labelId) {
            this.out.println(String.format("[%d,%d]%stx:%d,node:%d,label:%d", session, flush2, Character.valueOf(add2 ? (char)'+' : '-'), txId, nodeId, labelId));
        }

        @Override
        public void merge(boolean add2, long session, long flush2, long range2, int labelId, long existingBits, long newBits) {
            this.out.println(String.format("[%d,%d]%srange:%d,labelId:%d%n [%s]%n [%s]", session, flush2, Character.valueOf(add2 ? (char)'+' : '-'), range2, labelId, PrintStreamDumper.bits(existingBits, this.bitsAsChars), PrintStreamDumper.bits(newBits, this.bitsAsChars)));
        }

        private static String bits(long bits2, char[] bitsAsChars) {
            long mask = 1L;
            int i = 0;
            int c = 0;
            while (i < 64) {
                if (i % 8 == 0) {
                    ++c;
                }
                boolean set = (bits2 & mask) != 0L;
                bitsAsChars[bitsAsChars.length - c] = set ? 49 : 48;
                mask <<= 1;
                ++i;
                ++c;
            }
            return String.valueOf(bitsAsChars);
        }
    }

    public static interface Dumper {
        public void file(File var1);

        public void prepare(boolean var1, long var2, long var4, long var6, long var8, int var10);

        public void merge(boolean var1, long var2, long var4, long var6, int var8, long var9, long var11);
    }

    static class TxFilter {
        private final long[][] lowsAndHighs;
        private boolean contains;

        TxFilter(long[] ... lowsAndHighs) {
            this.lowsAndHighs = lowsAndHighs;
        }

        void clear() {
            this.contains = false;
        }

        boolean contains(long txId) {
            for (long[] filter2 : this.lowsAndHighs) {
                if (txId < filter2[0] || txId > filter2[1]) continue;
                this.contains = true;
                return true;
            }
            return false;
        }

        boolean contains() {
            return this.contains;
        }
    }
}

