/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.kernel.impl.index.labelscan.CompositeLabelScanValueIterator;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIndexProgressor;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValueIterator;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.storageengine.api.schema.IndexProgressor;
import org.neo4j.storageengine.api.schema.LabelScanReader;

class NativeLabelScanReader
implements LabelScanReader {
    private final GBPTree<LabelScanKey, LabelScanValue> index;
    private final Set<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> openCursors;

    NativeLabelScanReader(GBPTree<LabelScanKey, LabelScanValue> index) {
        this.index = index;
        this.openCursors = new HashSet<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>>();
    }

    @Override
    public void close() {
        try {
            this.ensureOpenCursorsClosed();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PrimitiveLongResourceIterator nodesWithLabel(int labelId) {
        RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor;
        try {
            cursor = this.seekerForLabel(0L, labelId);
            this.openCursors.add(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new LabelScanValueIterator(cursor, this.openCursors, -1L);
    }

    @Override
    public PrimitiveLongResourceIterator nodesWithAnyOfLabels(long fromId, int ... labelIds) {
        List<PrimitiveLongResourceIterator> iterators = this.iteratorsForLabels(fromId, labelIds);
        return new CompositeLabelScanValueIterator(iterators, false);
    }

    @Override
    public PrimitiveLongResourceIterator nodesWithAllLabels(int ... labelIds) {
        List<PrimitiveLongResourceIterator> iterators = this.iteratorsForLabels(-1L, labelIds);
        return new CompositeLabelScanValueIterator(iterators, true);
    }

    @Override
    public void nodesWithLabel(IndexProgressor.NodeLabelClient client, int labelId) {
        RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor;
        try {
            cursor = this.seekerForLabel(0L, labelId);
            this.openCursors.add(cursor);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        client.scan(new LabelScanValueIndexProgressor(cursor, this.openCursors, client), false, labelId);
    }

    private List<PrimitiveLongResourceIterator> iteratorsForLabels(long fromId, int[] labelIds) {
        ArrayList<PrimitiveLongResourceIterator> iterators = new ArrayList<PrimitiveLongResourceIterator>();
        try {
            for (int labelId : labelIds) {
                RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor = this.seekerForLabel(fromId, labelId);
                this.openCursors.add(cursor);
                iterators.add(new LabelScanValueIterator(cursor, this.openCursors, fromId));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return iterators;
    }

    private RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> seekerForLabel(long startId, int labelId) throws IOException {
        LabelScanKey from2 = new LabelScanKey(labelId, NativeLabelScanWriter.rangeOf(startId));
        LabelScanKey to2 = new LabelScanKey(labelId, Long.MAX_VALUE);
        return this.index.seek(from2, to2);
    }

    private void ensureOpenCursorsClosed() throws IOException {
        for (RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException> cursor : this.openCursors) {
            cursor.close();
        }
        this.openCursors.clear();
    }
}

