/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.StringJoiner;
import java.util.function.IntFunction;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

abstract class AbstractArrayType<T>
extends Type {
    private final ArrayElementComparator arrayElementComparator;
    private final ArrayElementValueFactory<T> valueFactory;
    final ArrayElementWriter arrayElementWriter;
    private final ArrayElementReader arrayElementReader;
    private final IntFunction<T[]> arrayCreator;
    private final ValueWriter.ArrayType arrayType;

    AbstractArrayType(ValueGroup valueGroup, byte typeId, ArrayElementComparator arrayElementComparator, ArrayElementValueFactory<T> valueFactory, ArrayElementWriter arrayElementWriter, ArrayElementReader arrayElementReader, IntFunction<T[]> arrayCreator, ValueWriter.ArrayType arrayType) {
        super(valueGroup, typeId, null, null);
        this.arrayElementComparator = arrayElementComparator;
        this.valueFactory = valueFactory;
        this.arrayElementWriter = arrayElementWriter;
        this.arrayElementReader = arrayElementReader;
        this.arrayCreator = arrayCreator;
        this.arrayType = arrayType;
    }

    @Override
    final void copyValue(GenericKey to2, GenericKey from2) {
        this.copyValue(to2, from2, from2.arrayLength);
    }

    abstract void copyValue(GenericKey var1, GenericKey var2, int var3);

    abstract void initializeArray(GenericKey var1, int var2, ValueWriter.ArrayType var3);

    @Override
    void minimalSplitter(GenericKey left2, GenericKey right2, GenericKey into) {
        int lastEqualIndex = -1;
        if (left2.type == right2.type) {
            int maxLength = Integer.min(left2.arrayLength, right2.arrayLength);
            for (int index = 0; index < maxLength && this.arrayElementComparator.compare(left2, right2, index) == 0; ++index) {
                ++lastEqualIndex;
            }
        }
        int length2 = Math.min(right2.arrayLength, lastEqualIndex + 2);
        this.copyValue(into, right2, length2);
        into.arrayLength = length2;
    }

    @Override
    int compareValue(GenericKey left2, GenericKey right2) {
        if (left2.isHighestArray || right2.isHighestArray) {
            return Boolean.compare(left2.isHighestArray, right2.isHighestArray);
        }
        int compare = 0;
        int length2 = Integer.min(left2.arrayLength, right2.arrayLength);
        for (int index = 0; compare == 0 && index < length2; ++index) {
            compare = this.arrayElementComparator.compare(left2, right2, index);
        }
        return compare == 0 ? Integer.compare(left2.arrayLength, right2.arrayLength) : compare;
    }

    @Override
    Value asValue(GenericKey state) {
        T[] array = this.arrayCreator.apply(state.arrayLength);
        for (int i = 0; i < state.arrayLength; ++i) {
            array[i] = this.valueFactory.from(state, i);
        }
        return Values.of(array);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        AbstractArrayType.putArray(cursor, state, this.arrayElementWriter);
    }

    @Override
    boolean readValue(PageCursor cursor, int size2, GenericKey into) {
        return AbstractArrayType.readArray(cursor, this.arrayType, this.arrayElementReader, into);
    }

    @Override
    void initializeAsLowest(GenericKey state) {
        state.initializeArrayMeta(0);
        this.initializeArray(state, 0, this.arrayType);
    }

    @Override
    void initializeAsHighest(GenericKey state) {
        state.initializeArrayMeta(0);
        this.initializeArray(state, 0, this.arrayType);
        state.isHighestArray = true;
    }

    int arrayKeySize(GenericKey key, int elementSize) {
        return 2 + key.arrayLength * elementSize;
    }

    static void putArrayHeader(PageCursor cursor, short arrayLength) {
        cursor.putShort(arrayLength);
    }

    static void putArrayItems(PageCursor cursor, GenericKey key, ArrayElementWriter itemWriter) {
        for (int i = 0; i < key.arrayLength; ++i) {
            itemWriter.write(cursor, key, i);
        }
    }

    static void putArray(PageCursor cursor, GenericKey key, ArrayElementWriter writer) {
        AbstractArrayType.putArrayHeader(cursor, GenericKey.toNonNegativeShortExact(key.arrayLength));
        AbstractArrayType.putArrayItems(cursor, key, writer);
    }

    static boolean readArray(PageCursor cursor, ValueWriter.ArrayType type, ArrayElementReader reader, GenericKey into) {
        if (!AbstractArrayType.setArrayLengthWhenReading(into, cursor, cursor.getShort())) {
            return false;
        }
        into.beginArray(into.arrayLength, type);
        for (int i = 0; i < into.arrayLength; ++i) {
            if (reader.readFrom(cursor, into)) continue;
            return false;
        }
        into.endArray();
        return true;
    }

    static boolean setArrayLengthWhenReading(GenericKey state, PageCursor cursor, short arrayLength) {
        state.arrayLength = arrayLength;
        if (state.arrayLength < 0 || state.arrayLength > 4096) {
            GenericKey.setCursorException(cursor, "non-valid array length, " + state.arrayLength);
            state.arrayLength = 0;
            return false;
        }
        return true;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("isHighestArray=" + state.isHighestArray);
        joiner.add("arrayLength=" + state.arrayLength);
        joiner.add("currentArrayOffset=" + state.currentArrayOffset);
    }

    @FunctionalInterface
    static interface ArrayElementValueFactory<T> {
        public T from(GenericKey var1, int var2);
    }

    @FunctionalInterface
    static interface ArrayElementWriter {
        public void write(PageCursor var1, GenericKey var2, int var3);
    }

    @FunctionalInterface
    static interface ArrayElementReader {
        public boolean readFrom(PageCursor var1, GenericKey var2);
    }

    @FunctionalInterface
    static interface ArrayElementComparator {
        public int compare(GenericKey var1, GenericKey var2, int var3);
    }
}

