/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.cursor.RawCursor;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockEntryReader;
import org.neo4j.kernel.impl.index.schema.BlockReader;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.IndexKeyStorage;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateStorage;
import org.neo4j.kernel.impl.index.schema.MergingBlockEntryReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsWriter;
import org.neo4j.memory.LocalMemoryTracker;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.storageengine.api.schema.PopulationProgress;
import org.neo4j.storageengine.api.schema.StoreIndexDescriptor;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.Runnables;
import org.neo4j.values.storable.Value;

public abstract class BlockBasedIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulator<KEY, VALUE> {
    private static final String BLOCK_SIZE = FeatureToggles.getString(BlockBasedIndexPopulator.class, "blockSize", "1M");
    private static final int MERGE_FACTOR = FeatureToggles.getInteger(BlockBasedIndexPopulator.class, "mergeFactor", 8);
    private final IndexDirectoryStructure directoryStructure;
    private final IndexDropAction dropAction;
    private final boolean archiveFailedIndex;
    private final int blockSize;
    private final int mergeFactor;
    private final BlockStorage.Monitor blockStorageMonitor;
    private final List<ThreadLocalBlockStorage> allScanUpdates = new CopyOnWriteArrayList<ThreadLocalBlockStorage>();
    private final ThreadLocal<ThreadLocalBlockStorage> scanUpdates;
    private final ByteBufferFactory bufferFactory;
    private IndexUpdateStorage<KEY, VALUE> externalUpdates;
    private volatile boolean scanCompleted;
    private final CloseCancellation cancellation = new CloseCancellation();
    private volatile CountDownLatch mergeOngoingLatch;
    private volatile long numberOfAppliedScanUpdates;
    private volatile long numberOfAppliedExternalUpdates;

    BlockBasedIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File file, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettingsCache spatialSettings, IndexDirectoryStructure directoryStructure, IndexDropAction dropAction, boolean archiveFailedIndex) {
        this(pageCache, fs, file, layout, monitor, descriptor, spatialSettings, directoryStructure, dropAction, archiveFailedIndex, BlockBasedIndexPopulator.parseBlockSize(), MERGE_FACTOR, BlockStorage.Monitor.NO_MONITOR, new LocalMemoryTracker());
    }

    BlockBasedIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File file, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, StoreIndexDescriptor descriptor, IndexSpecificSpaceFillingCurveSettingsCache spatialSettings, IndexDirectoryStructure directoryStructure, IndexDropAction dropAction, boolean archiveFailedIndex, int blockSize, int mergeFactor, BlockStorage.Monitor blockStorageMonitor, MemoryAllocationTracker memoryTracker) {
        super(pageCache, fs, file, layout, monitor, descriptor, new SpaceFillingCurveSettingsWriter(spatialSettings));
        this.directoryStructure = directoryStructure;
        this.dropAction = dropAction;
        this.archiveFailedIndex = archiveFailedIndex;
        this.blockSize = blockSize;
        this.mergeFactor = mergeFactor;
        this.blockStorageMonitor = blockStorageMonitor;
        this.scanUpdates = ThreadLocal.withInitial(this::newThreadLocalBlockStorage);
        this.bufferFactory = new UnsafeDirectByteBufferFactory(memoryTracker);
    }

    private synchronized ThreadLocalBlockStorage newThreadLocalBlockStorage() {
        Preconditions.checkState(!this.cancellation.cancelled(), "Already closed");
        Preconditions.checkState(!this.scanCompleted, "Scan has already been completed");
        try {
            int id2 = this.allScanUpdates.size();
            ThreadLocalBlockStorage blockStorage = new ThreadLocalBlockStorage(id2);
            this.allScanUpdates.add(blockStorage);
            return blockStorage;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int parseBlockSize() {
        long blockSize = ByteUnit.parse(BLOCK_SIZE);
        Preconditions.checkArgument(blockSize >= 20L && blockSize < Integer.MAX_VALUE, "Block size need to fit in int. Was " + blockSize, new Object[0]);
        return (int)blockSize;
    }

    @Override
    public void create() {
        try {
            NativeIndexes.deleteIndex(this.fileSystem, this.directoryStructure, this.descriptor.getId(), this.archiveFailedIndex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        super.create();
        try {
            File externalUpdatesFile = new File(this.storeFile.getParent(), this.storeFile.getName() + ".ext");
            this.externalUpdates = new IndexUpdateStorage(this.fileSystem, externalUpdatesFile, this.bufferFactory, this.blockSize, this.layout);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        if (!updates.isEmpty()) {
            BlockStorage blockStorage = this.scanUpdates.get().blockStorage;
            for (IndexEntryUpdate<?> update2 : updates) {
                this.storeUpdate(update2, blockStorage);
            }
        }
    }

    private void storeUpdate(long entityId, Value[] values2, BlockStorage<KEY, VALUE> blockStorage) {
        try {
            NativeIndexKey key = (NativeIndexKey)this.layout.newKey();
            Object value2 = this.layout.newValue();
            NativeIndexUpdater.initializeKeyFromUpdate(key, entityId, values2);
            ((NativeIndexValue)value2).from(values2);
            blockStorage.add(key, value2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void storeUpdate(IndexEntryUpdate<?> update2, BlockStorage<KEY, VALUE> blockStorage) {
        this.storeUpdate(update2.getEntityId(), update2.values(), blockStorage);
    }

    private synchronized boolean markMergeStarted() {
        this.scanCompleted = true;
        if (this.cancellation.cancelled()) {
            return false;
        }
        this.mergeOngoingLatch = new CountDownLatch(1);
        return true;
    }

    @Override
    public void scanCompleted(PhaseTracker phaseTracker) throws IndexEntryConflictException {
        if (!this.markMergeStarted()) {
            return;
        }
        try {
            phaseTracker.enterPhase(PhaseTracker.Phase.MERGE);
            if (!this.allScanUpdates.isEmpty()) {
                this.mergeScanUpdates();
            }
            this.externalUpdates.doneAdding();
            phaseTracker.enterPhase(PhaseTracker.Phase.BUILD);
            File duplicatesFile = new File(this.storeFile.getParentFile(), this.storeFile.getName() + ".dup");
            try (IndexKeyStorage indexKeyStorage = new IndexKeyStorage(this.fileSystem, duplicatesFile, this.bufferFactory, this.blockSize, this.layout);){
                RecordingConflictDetector recordingConflictDetector = new RecordingConflictDetector(!this.descriptor.isUnique(), indexKeyStorage);
                this.writeScanUpdatesToTree(recordingConflictDetector);
                phaseTracker.enterPhase(PhaseTracker.Phase.APPLY_EXTERNAL);
                this.writeExternalUpdatesToTree(recordingConflictDetector);
                if (this.descriptor.isUnique()) {
                    this.verifyUniqueKeys(recordingConflictDetector.allConflicts());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Got interrupted, so merge not completed", e);
        }
        catch (ExecutionException e) {
            Throwable executionException = e.getCause();
            if (executionException instanceof RuntimeException) {
                throw (RuntimeException)executionException;
            }
            throw new RuntimeException(executionException);
        }
        finally {
            this.mergeOngoingLatch.countDown();
        }
    }

    private void mergeScanUpdates() throws InterruptedException, ExecutionException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.allScanUpdates.size());
        ArrayList<Future<Object>> mergeFutures = new ArrayList<Future<Object>>();
        for (ThreadLocalBlockStorage threadLocalBlockStorage : this.allScanUpdates) {
            BlockStorage scanUpdates = threadLocalBlockStorage.blockStorage;
            mergeFutures.add(executorService.submit(() -> {
                scanUpdates.doneAdding();
                scanUpdates.merge(this.mergeFactor, this.cancellation);
                return null;
            }));
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
        for (Future future : mergeFutures) {
            future.get();
        }
    }

    private void writeExternalUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector) throws IOException, IndexEntryConflictException {
        try (Writer writer = this.tree.writer();
             IndexUpdateCursor updates = (IndexUpdateCursor)this.externalUpdates.reader();){
            while (updates.next() && !this.cancellation.cancelled()) {
                switch (updates.updateMode()) {
                    case ADDED: {
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)updates.key(), (NativeIndexValue)updates.value());
                        break;
                    }
                    case REMOVED: {
                        writer.remove(updates.key());
                        break;
                    }
                    case CHANGED: {
                        writer.remove(updates.key());
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)updates.key2(), (NativeIndexValue)updates.value());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown update mode " + (Object)((Object)updates.updateMode()));
                    }
                }
                ++this.numberOfAppliedExternalUpdates;
            }
        }
    }

    private void verifyUniqueKeys(IndexKeyStorage.KeyEntryCursor<KEY> allConflictingKeys) throws IOException, IndexEntryConflictException {
        while (allConflictingKeys.next() && !this.cancellation.cancelled()) {
            NativeIndexKey key = (NativeIndexKey)allConflictingKeys.key();
            key.setCompareId(false);
            this.verifyUniqueSeek(this.tree.seek(key, key));
        }
    }

    private void verifyUniqueSeek(RawCursor<Hit<KEY, VALUE>, IOException> seek) throws IOException, IndexEntryConflictException {
        if (seek != null && seek.next()) {
            long firstEntityId = ((NativeIndexKey)((Hit)seek.get()).key()).getEntityId();
            if (seek.next()) {
                long secondEntityId = ((NativeIndexKey)((Hit)seek.get()).key()).getEntityId();
                throw new IndexEntryConflictException(firstEntityId, secondEntityId, ((NativeIndexKey)((Hit)seek.get()).key()).asValues());
            }
        }
    }

    private void writeScanUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector) throws IOException, IndexEntryConflictException {
        try (MergingBlockEntryReader allEntries = new MergingBlockEntryReader(this.layout);){
            for (ThreadLocalBlockStorage part : this.allScanUpdates) {
                BlockReader reader = part.blockStorage.reader();
                Throwable throwable = null;
                try {
                    BlockEntryReader singleMergedBlock = reader.nextBlock();
                    if (singleMergedBlock == null) continue;
                    allEntries.addSource(singleMergedBlock);
                    if (reader.nextBlock() == null) continue;
                    throw new IllegalStateException("Final BlockStorage had multiple blocks");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            boolean asMuchAsPossibleToTheLeft = true;
            try (Writer writer = this.tree.writer((double)asMuchAsPossibleToTheLeft);){
                while (allEntries.next() && !this.cancellation.cancelled()) {
                    this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)allEntries.key(), (NativeIndexValue)allEntries.value());
                    ++this.numberOfAppliedScanUpdates;
                }
            }
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater() {
        if (this.scanCompleted) {
            return super.newPopulatingUpdater();
        }
        return new IndexUpdater(){
            private volatile boolean closed;

            @Override
            public void process(IndexEntryUpdate<?> update2) {
                this.assertOpen();
                try {
                    BlockBasedIndexPopulator.this.externalUpdates.add(update2);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Override
            public void close() {
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    @Override
    public synchronized void drop() {
        Runnable[] runnableArray = new Runnable[4];
        runnableArray[0] = this::closeBlockStorage;
        runnableArray[1] = this.bufferFactory::close;
        runnableArray[2] = () -> super.drop();
        runnableArray[3] = () -> this.dropAction.drop(this.descriptor.getId(), this.archiveFailedIndex);
        Runnables.runAll("Failed while trying to drop index", runnableArray);
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        Runnable[] runnableArray = new Runnable[3];
        runnableArray[0] = this::closeBlockStorage;
        runnableArray[1] = this.bufferFactory::close;
        runnableArray[2] = () -> super.close(populationCompletedSuccessfully);
        Runnables.runAll("Failed while trying to close index", runnableArray);
    }

    private void closeBlockStorage() {
        this.cancellation.setCancel();
        if (this.mergeOngoingLatch != null) {
            try {
                this.mergeOngoingLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        List toClose = this.allScanUpdates.stream().map(local -> ((ThreadLocalBlockStorage)local).blockStorage).collect(Collectors.toCollection(ArrayList::new));
        toClose.add(this.externalUpdates);
        IOUtils.closeAllUnchecked(toClose);
    }

    @Override
    public PopulationProgress progress(PopulationProgress scanProgress) {
        PopulationProgress treeBuildProgress;
        PopulationProgress.MultiBuilder builder = PopulationProgress.multiple();
        builder.add(scanProgress, 4.0f);
        if (!this.allScanUpdates.isEmpty()) {
            long completed = 0L;
            long total2 = 0L;
            if (this.scanCompleted) {
                ThreadLocalBlockStorage part2 = Iterables.first(this.allScanUpdates);
                completed = part2.entriesMerged;
                total2 = part2.totalEntriesToMerge;
            }
            builder.add(PopulationProgress.single(completed, total2), 1.0f);
        }
        if (this.allScanUpdates.stream().allMatch(part -> ((ThreadLocalBlockStorage)part).mergeStarted)) {
            long entryCount = this.allScanUpdates.stream().mapToLong(part -> ((ThreadLocalBlockStorage)part).count).sum() + this.externalUpdates.count();
            treeBuildProgress = PopulationProgress.single(this.numberOfAppliedScanUpdates + this.numberOfAppliedExternalUpdates, entryCount);
        } else {
            treeBuildProgress = PopulationProgress.NONE;
        }
        builder.add(treeBuildProgress, 2.0f);
        return builder.build();
    }

    private void writeToTree(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value2) throws IndexEntryConflictException {
        recordingConflictDetector.controlConflictDetection(key);
        writer.merge(key, value2, recordingConflictDetector);
        this.handleMergeConflict(writer, recordingConflictDetector, key, value2);
    }

    private void handleMergeConflict(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value2) throws IndexEntryConflictException {
        if (recordingConflictDetector.wasConflicting()) {
            NativeIndexKey copy2 = (NativeIndexKey)this.layout.newKey();
            this.layout.copyKey(key, copy2);
            recordingConflictDetector.reportConflict(copy2);
            recordingConflictDetector.relaxUniqueness(key);
            writer.put(key, value2);
        }
    }

    private static class RecordingConflictDetector<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    extends ConflictDetectingValueMerger<KEY, VALUE, KEY> {
        private final IndexKeyStorage<KEY> allConflictingKeys;

        RecordingConflictDetector(boolean compareEntityIds, IndexKeyStorage<KEY> indexKeyStorage) {
            super(compareEntityIds);
            this.allConflictingKeys = indexKeyStorage;
        }

        @Override
        void doReportConflict(long existingNodeId, long addedNodeId, KEY conflictingKey) {
            try {
                this.allConflictingKeys.add(conflictingKey);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        IndexKeyStorage.KeyEntryCursor<KEY> allConflicts() throws IOException {
            this.allConflictingKeys.doneAdding();
            return (IndexKeyStorage.KeyEntryCursor)this.allConflictingKeys.reader();
        }

        void relaxUniqueness(KEY key) {
            ((NativeIndexKey)key).setCompareId(true);
        }
    }

    private static class CloseCancellation
    implements BlockStorage.Cancellation {
        private volatile boolean cancelled;

        private CloseCancellation() {
        }

        void setCancel() {
            this.cancelled = true;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }
    }

    private class ThreadLocalBlockStorage
    extends BlockStorage.Monitor.Delegate {
        private final BlockStorage<KEY, VALUE> blockStorage;
        private volatile long count;
        private volatile boolean mergeStarted;
        private volatile long totalEntriesToMerge;
        private volatile long entriesMerged;

        ThreadLocalBlockStorage(int id2) throws IOException {
            super(BlockBasedIndexPopulator.this.blockStorageMonitor);
            File blockFile = new File(BlockBasedIndexPopulator.this.storeFile.getParentFile(), BlockBasedIndexPopulator.this.storeFile.getName() + ".scan-" + id2);
            this.blockStorage = new BlockStorage(BlockBasedIndexPopulator.this.layout, BlockBasedIndexPopulator.this.bufferFactory, BlockBasedIndexPopulator.this.fileSystem, blockFile, this, BlockBasedIndexPopulator.this.blockSize);
        }

        @Override
        public void mergeStarted(long entryCount, long totalEntriesToWriteDuringMerge) {
            super.mergeStarted(entryCount, totalEntriesToWriteDuringMerge);
            this.count = entryCount;
            this.totalEntriesToMerge = totalEntriesToWriteDuringMerge;
            this.mergeStarted = true;
        }

        @Override
        public void entriesMerged(int entries) {
            super.entriesMerged(entries);
            this.entriesMerged += (long)entries;
        }
    }
}

