/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.DynamicSizeUtil;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;

class BlockEntry<KEY, VALUE> {
    private final KEY key;
    private final VALUE value;

    BlockEntry(KEY key, VALUE value2) {
        this.key = key;
        this.value = value2;
    }

    KEY key() {
        return this.key;
    }

    VALUE value() {
        return this.value;
    }

    public String toString() {
        return String.format("[%s=%s]", this.key, this.value);
    }

    static <VALUE, KEY> int entrySize(Layout<KEY, VALUE> layout, KEY key, VALUE value2) {
        int keySize = layout.keySize(key);
        int valueSize = layout.valueSize(value2);
        return keySize + valueSize + DynamicSizeUtil.getOverhead(keySize, valueSize);
    }

    static <VALUE, KEY> int keySize(Layout<KEY, VALUE> layout, KEY key) {
        int keySize = layout.keySize(key);
        return keySize + DynamicSizeUtil.getOverhead(keySize, 0);
    }

    static <KEY, VALUE> BlockEntry<KEY, VALUE> read(PageCursor pageCursor, Layout<KEY, VALUE> layout) {
        KEY key = layout.newKey();
        VALUE value2 = layout.newValue();
        BlockEntry.read(pageCursor, layout, key, value2);
        return new BlockEntry<KEY, VALUE>(key, value2);
    }

    static <KEY, VALUE> void read(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key, VALUE value2) {
        long entrySize = DynamicSizeUtil.readKeyValueSize(pageCursor);
        layout.readKey(pageCursor, key, DynamicSizeUtil.extractKeySize(entrySize));
        layout.readValue(pageCursor, value2, DynamicSizeUtil.extractValueSize(entrySize));
    }

    static <KEY, VALUE> void read(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key) {
        long entrySize = DynamicSizeUtil.readKeyValueSize(pageCursor);
        layout.readKey(pageCursor, key, DynamicSizeUtil.extractKeySize(entrySize));
    }

    static <KEY, VALUE> void write(PageCursor pageCursor, Layout<KEY, VALUE> layout, BlockEntry<KEY, VALUE> entry) {
        BlockEntry.write(pageCursor, layout, entry.key(), entry.value());
    }

    static <KEY, VALUE> void write(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key, VALUE value2) {
        int keySize = layout.keySize(key);
        int valueSize = layout.valueSize(value2);
        DynamicSizeUtil.putKeyValueSize(pageCursor, keySize, valueSize);
        layout.writeKey(pageCursor, key);
        layout.writeValue(pageCursor, value2);
    }

    static <KEY, VALUE> void write(PageCursor pageCursor, Layout<KEY, VALUE> layout, KEY key) {
        int keySize = layout.keySize(key);
        DynamicSizeUtil.putKeyValueSize(pageCursor, keySize, 0);
        layout.writeKey(pageCursor, key);
    }
}

