/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OpenMode;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.index.schema.BlockEntryReader;
import org.neo4j.kernel.impl.index.schema.ByteBufferFactory;
import org.neo4j.kernel.impl.index.schema.ReadableChannelPageCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;

public class BlockReader<KEY, VALUE>
implements Closeable {
    private final StoreChannel channel;
    private final FileSystemAbstraction fs;
    private final File file;
    private final Layout<KEY, VALUE> layout;
    private final ByteBufferFactory byteBufferFactory;
    private final int blockSize;

    BlockReader(FileSystemAbstraction fs, File file, Layout<KEY, VALUE> layout, ByteBufferFactory byteBufferFactory, int blockSize) throws IOException {
        this.fs = fs;
        this.file = file;
        this.layout = layout;
        this.byteBufferFactory = byteBufferFactory;
        this.blockSize = blockSize;
        this.channel = fs.open(file, OpenMode.READ);
    }

    BlockEntryReader<KEY, VALUE> nextBlock() throws IOException {
        long position2 = this.channel.position();
        if (position2 >= this.channel.size()) {
            return null;
        }
        StoreChannel blockChannel = this.fs.open(this.file, OpenMode.READ);
        blockChannel.position(position2);
        ReadableChannelPageCursor pageCursor = new ReadableChannelPageCursor(new ReadAheadChannel<StoreChannel>(blockChannel, this.byteBufferFactory.newBuffer(this.blockSize)));
        BlockEntryReader<KEY, VALUE> blockEntryReader = new BlockEntryReader<KEY, VALUE>(pageCursor, this.layout);
        long blockSize = blockEntryReader.blockSize();
        this.channel.position(position2 + blockSize);
        return blockEntryReader;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

