/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.BooleanType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class BooleanArrayType
extends AbstractArrayType<Boolean> {
    BooleanArrayType(byte typeId) {
        super(ValueGroup.BOOLEAN_ARRAY, typeId, (o1, o2, i) -> BooleanType.compare(o1.long0Array[i], o2.long0Array[i]), null, (c, k, i) -> BooleanType.put(c, k.long0Array[i]), BooleanType::read, null, ValueWriter.ArrayType.BOOLEAN);
    }

    @Override
    int valueSize(GenericKey state) {
        return this.arrayKeySize(state, 1);
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2, int length2) {
        this.initializeArray(to2, length2, null);
        System.arraycopy(from2.long0Array, 0, to2.long0Array, 0, length2);
    }

    @Override
    void initializeArray(GenericKey key, int length2, ValueWriter.ArrayType arrayType) {
        key.long0Array = BooleanArrayType.ensureBigEnough(key.long0Array, length2);
    }

    @Override
    Value asValue(GenericKey state) {
        boolean[] array = new boolean[state.arrayLength];
        for (int i = 0; i < state.arrayLength; ++i) {
            array[i] = BooleanType.asValueRaw(state.long0Array[i]);
        }
        return Values.of(array);
    }

    void write(GenericKey state, int offset, boolean value2) {
        state.long0Array[offset] = value2 ? 1L : 0L;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

