/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.DateIndexKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

class DateLayout
extends IndexLayout<DateIndexKey, NativeIndexValue> {
    DateLayout() {
        super("Tda", 0, 1);
    }

    @Override
    public DateIndexKey newKey() {
        return new DateIndexKey();
    }

    @Override
    public DateIndexKey copyKey(DateIndexKey key, DateIndexKey into) {
        into.epochDay = key.epochDay;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    @Override
    public int keySize(DateIndexKey key) {
        return 16;
    }

    @Override
    public void writeKey(PageCursor cursor, DateIndexKey key) {
        cursor.putLong(key.epochDay);
        cursor.putLong(key.getEntityId());
    }

    @Override
    public void readKey(PageCursor cursor, DateIndexKey into, int keySize) {
        into.epochDay = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

