/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.kernel.impl.index.schema.AbstractArrayType;
import org.neo4j.kernel.impl.index.schema.DurationType;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueWriter;

class DurationArrayType
extends AbstractArrayType<DurationValue> {
    DurationArrayType(byte typeId) {
        super(ValueGroup.DURATION_ARRAY, typeId, (o1, o2, i) -> DurationType.compare(o1.long0Array[i], o1.long1Array[i], o1.long2Array[i], o1.long3Array[i], o2.long0Array[i], o2.long1Array[i], o2.long2Array[i], o2.long3Array[i]), (k, i) -> DurationType.asValue(k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), (c, k, i) -> DurationType.put(c, k.long0Array[i], k.long1Array[i], k.long2Array[i], k.long3Array[i]), DurationType::read, DurationValue[]::new, ValueWriter.ArrayType.DURATION);
    }

    @Override
    int valueSize(GenericKey state) {
        return this.arrayKeySize(state, 28);
    }

    @Override
    void copyValue(GenericKey to2, GenericKey from2, int length2) {
        this.initializeArray(to2, length2, null);
        System.arraycopy(from2.long0Array, 0, to2.long0Array, 0, length2);
        System.arraycopy(from2.long1Array, 0, to2.long1Array, 0, length2);
        System.arraycopy(from2.long2Array, 0, to2.long2Array, 0, length2);
        System.arraycopy(from2.long3Array, 0, to2.long3Array, 0, length2);
    }

    @Override
    void initializeArray(GenericKey key, int length2, ValueWriter.ArrayType arrayType) {
        key.long0Array = DurationArrayType.ensureBigEnough(key.long0Array, length2);
        key.long1Array = DurationArrayType.ensureBigEnough(key.long1Array, length2);
        key.long2Array = DurationArrayType.ensureBigEnough(key.long2Array, length2);
        key.long3Array = DurationArrayType.ensureBigEnough(key.long3Array, length2);
    }

    void write(GenericKey state, int offset, long months, long days, long totalAvgSeconds, int nanos) {
        state.long0Array[offset] = totalAvgSeconds;
        state.long1Array[offset] = nanos;
        state.long2Array[offset] = months;
        state.long3Array[offset] = days;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0Array=" + Arrays.toString(state.long0Array));
        joiner.add("long1Array=" + Arrays.toString(state.long1Array));
        joiner.add("long2Array=" + Arrays.toString(state.long2Array));
        joiner.add("long3Array=" + Arrays.toString(state.long3Array));
        super.addTypeSpecificDetails(joiner, state);
    }
}

