/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.DurationIndexKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

class DurationLayout
extends IndexLayout<DurationIndexKey, NativeIndexValue> {
    DurationLayout() {
        super("Tdu", 0, 1);
    }

    @Override
    public DurationIndexKey newKey() {
        return new DurationIndexKey();
    }

    @Override
    public DurationIndexKey copyKey(DurationIndexKey key, DurationIndexKey into) {
        into.totalAvgSeconds = key.totalAvgSeconds;
        into.nanosOfSecond = key.nanosOfSecond;
        into.months = key.months;
        into.days = key.days;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    @Override
    public int keySize(DurationIndexKey key) {
        return 36;
    }

    @Override
    public void writeKey(PageCursor cursor, DurationIndexKey key) {
        cursor.putLong(key.totalAvgSeconds);
        cursor.putInt(key.nanosOfSecond);
        cursor.putLong(key.months);
        cursor.putLong(key.days);
        cursor.putLong(key.getEntityId());
    }

    @Override
    public void readKey(PageCursor cursor, DurationIndexKey into, int keySize) {
        into.totalAvgSeconds = cursor.getLong();
        into.nanosOfSecond = cursor.getInt();
        into.months = cursor.getLong();
        into.days = cursor.getLong();
        into.setEntityId(cursor.getLong());
    }
}

