/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.Arrays;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.util.Validator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Value;

class GenericIndexKeyValidator
implements Validator<Value[]> {
    private final int maxLength;
    private final Layout<GenericKey, NativeIndexValue> layout;

    GenericIndexKeyValidator(int maxLength, Layout<GenericKey, NativeIndexValue> layout) {
        this.maxLength = maxLength;
        this.layout = layout;
    }

    @Override
    public void validate(Value[] values2) {
        int size2;
        int worstCaseSize = GenericIndexKeyValidator.worstCaseLength(values2);
        if (worstCaseSize > this.maxLength && (size2 = this.actualLength(values2)) > this.maxLength) {
            throw new IllegalArgumentException(String.format("Property value size:%d of %s is too large to index into this particular index. Please see index documentation for limitations.", size2, Arrays.toString(values2)));
        }
    }

    private static int worstCaseLength(Value[] values2) {
        int length2 = 8;
        for (Value value2 : values2) {
            length2 += 8;
            length2 += GenericIndexKeyValidator.worstCaseLength(value2);
        }
        return length2;
    }

    private static int worstCaseLength(AnyValue value2) {
        if (value2.isSequenceValue()) {
            SequenceValue sequenceValue = (SequenceValue)((Object)value2);
            if (sequenceValue instanceof TextArray) {
                TextArray textArray = (TextArray)sequenceValue;
                int length2 = 0;
                for (int i = 0; i < textArray.length(); ++i) {
                    length2 += GenericIndexKeyValidator.stringWorstCaseLength(textArray.stringValue(i).length());
                }
                return length2;
            }
            return sequenceValue.length() * 32;
        }
        switch (((Value)value2).valueGroup().category()) {
            case TEXT: {
                return GenericIndexKeyValidator.stringWorstCaseLength(((TextValue)value2).length());
            }
        }
        return 32;
    }

    private static int stringWorstCaseLength(int stringLength) {
        return 2 + stringLength * 4;
    }

    private int actualLength(Value[] values2) {
        GenericKey key = this.layout.newKey();
        key.initialize(0L);
        for (int i = 0; i < values2.length; ++i) {
            key.initFromValue(i, values2[i], NativeIndexKey.Inclusion.NEUTRAL);
        }
        return key.size();
    }
}

