/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.CompositeGenericKey;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettingsCache;

class GenericLayout
extends IndexLayout<GenericKey, NativeIndexValue> {
    private final int numberOfSlots;
    private final IndexSpecificSpaceFillingCurveSettingsCache spatialSettings;

    GenericLayout(int numberOfSlots, IndexSpecificSpaceFillingCurveSettingsCache spatialSettings) {
        super("NSIL", 0, 5);
        this.numberOfSlots = numberOfSlots;
        this.spatialSettings = spatialSettings;
    }

    @Override
    public GenericKey newKey() {
        return this.numberOfSlots == 1 ? new GenericKey(this.spatialSettings) : new CompositeGenericKey(this.numberOfSlots, this.spatialSettings);
    }

    @Override
    public GenericKey copyKey(GenericKey key, GenericKey into) {
        into.copyFrom(key);
        return into;
    }

    @Override
    public int keySize(GenericKey key) {
        return key.size();
    }

    @Override
    public void writeKey(PageCursor cursor, GenericKey key) {
        key.put(cursor);
    }

    @Override
    public void readKey(PageCursor cursor, GenericKey into, int keySize) {
        into.get(cursor, keySize);
    }

    @Override
    public boolean fixedSize() {
        return false;
    }

    @Override
    public void minimalSplitter(GenericKey left2, GenericKey right2, GenericKey into) {
        right2.minimalSplitter(left2, right2, into);
    }

    IndexSpecificSpaceFillingCurveSettingsCache getSpaceFillingCurveSettings() {
        return this.spatialSettings;
    }
}

