/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

abstract class IndexLayout<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends Layout.Adapter<KEY, VALUE> {
    private final long identifier;
    private final int majorVersion;
    private final int minorVersion;

    IndexLayout(long identifier2, int majorVersion, int minorVersion) {
        this.identifier = identifier2;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    IndexLayout(String layoutName, int majorVersion, int minorVersion) {
        this(Layout.namedIdentifier(layoutName, 0), majorVersion, minorVersion);
    }

    @Override
    public VALUE newValue() {
        return (VALUE)NativeIndexValue.INSTANCE;
    }

    @Override
    public int valueSize(NativeIndexValue nativeIndexValue) {
        return 0;
    }

    @Override
    public void writeValue(PageCursor cursor, NativeIndexValue nativeIndexValue) {
    }

    @Override
    public void readValue(PageCursor cursor, NativeIndexValue into, int valueSize) {
    }

    @Override
    public boolean fixedSize() {
        return true;
    }

    @Override
    public long identifier() {
        return this.identifier;
    }

    @Override
    public int majorVersion() {
        return this.majorVersion;
    }

    @Override
    public int minorVersion() {
        return this.minorVersion;
    }

    @Override
    public final int compare(KEY o1, KEY o2) {
        int valueComparison = this.compareValue(o1, o2);
        if (valueComparison == 0 && ((NativeIndexKey)o1).getCompareId() & ((NativeIndexKey)o2).getCompareId()) {
            return Long.compare(((NativeIndexKey)o1).getEntityId(), ((NativeIndexKey)o2).getEntityId());
        }
        return valueComparison;
    }

    int compareValue(KEY o1, KEY o2) {
        return ((NativeIndexKey)o1).compareValueTo(o2);
    }
}

