/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.NativeIndexSingleValueKey;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class LocalDateTimeIndexKey
extends NativeIndexSingleValueKey<LocalDateTimeIndexKey> {
    static final int SIZE = 20;
    int nanoOfSecond;
    long epochSecond;

    LocalDateTimeIndexKey() {
    }

    @Override
    public Value asValue() {
        return LocalDateTimeValue.localDateTime(this.epochSecond, this.nanoOfSecond);
    }

    @Override
    public void initValueAsLowest(ValueGroup valueGroups) {
        this.epochSecond = Long.MIN_VALUE;
        this.nanoOfSecond = Integer.MIN_VALUE;
    }

    @Override
    public void initValueAsHighest(ValueGroup valueGroups) {
        this.epochSecond = Long.MAX_VALUE;
        this.nanoOfSecond = Integer.MAX_VALUE;
    }

    @Override
    public int compareValueTo(LocalDateTimeIndexKey other2) {
        int compare = Long.compare(this.epochSecond, other2.epochSecond);
        if (compare == 0) {
            compare = Integer.compare(this.nanoOfSecond, other2.nanoOfSecond);
        }
        return compare;
    }

    public String toString() {
        return String.format("value=%s,entityId=%d,epochSecond=%d,nanoOfSecond=%d", this.asValue(), this.getEntityId(), this.epochSecond, this.nanoOfSecond);
    }

    @Override
    public void writeLocalDateTime(long epochSecond, int nano) {
        this.nanoOfSecond = nano;
        this.epochSecond = epochSecond;
    }

    @Override
    protected Value assertCorrectType(Value value2) {
        if (!(value2 instanceof LocalDateTimeValue)) {
            throw new IllegalArgumentException("Key layout does only support LocalDateTimeValue, tried to create key from " + value2);
        }
        return value2;
    }
}

