/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.LocalDateTimeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

class LocalDateTimeLayout
extends IndexLayout<LocalDateTimeIndexKey, NativeIndexValue> {
    LocalDateTimeLayout() {
        super("Tld", 0, 1);
    }

    @Override
    public LocalDateTimeIndexKey newKey() {
        return new LocalDateTimeIndexKey();
    }

    @Override
    public LocalDateTimeIndexKey copyKey(LocalDateTimeIndexKey key, LocalDateTimeIndexKey into) {
        into.epochSecond = key.epochSecond;
        into.nanoOfSecond = key.nanoOfSecond;
        into.setEntityId(key.getEntityId());
        into.setCompareId(key.getCompareId());
        return into;
    }

    @Override
    public int keySize(LocalDateTimeIndexKey key) {
        return 20;
    }

    @Override
    public void writeKey(PageCursor cursor, LocalDateTimeIndexKey key) {
        cursor.putLong(key.epochSecond);
        cursor.putInt(key.nanoOfSecond);
        cursor.putLong(key.getEntityId());
    }

    @Override
    public void readKey(PageCursor cursor, LocalDateTimeIndexKey into, int keySize) {
        into.epochSecond = cursor.getLong();
        into.nanoOfSecond = cursor.getInt();
        into.setEntityId(cursor.getLong());
    }
}

